<br>
<br>
<br>

<div  style="text-align: center;font-size: 70px;">
MQTT协议接口说明
</div>


<div  style="text-align: center;font-size: 30px;">
Ver1.1.0
</div>
<br>
<br>
<br>
<br>
<br>
<br>

<div  style="text-align: center;font-size: 30px;">
长沙中天电子设计开发有限公司
</div>

<br>

<div  style="text-align: center;font-size: 30px;">
二〇二四年三月
</div>

<br>
<br>
<br>
<br>

文件控制：

文件名：MQTT接口说明

起草人：

最新版本作者： 
<br>
<br>
| 文档版本 | 日期 | 作者 | 版本说明 |
|---|---|---|---|
|5.1.1| 2024年03月27日|软件组|1.  初始版|


<br>

[TOC]

# 前言

  
## 背景

方便客户基于C200K基站设备使用 通信基站数据接收及解析。

  
## 编写目的

此说明书是为了说明协议内容，开发流程，方便基于此进行二次开发。

 
##  读者对象

1. 相关研发人员
2. 方案制定人员
3. 决策人员


# 开发流程

C200K基站，采用MQTT协议进行开发，基站接入MQTT服务器，应用从MQTT服务器下发指令和接收数据

整个交互图如下:

![](img/mqtt_1.png)

  
## MQTT服务器准备

MQTT服务器要求：

能够正常收发MQTT数据。

服务器的性能参数由业务决定。

域名：

公网域名或ip或者基站所处局域网ip。

MQTT服务器配置结果检查

使用MQTT.FX客户端，配置域名，端口，用户名和密码信息，然后连接，如果提示连接成功，则表示MQTT服务器可用。基站client id 是基站编号。

![](img/mqtt_2.png)

## 协议简介

    
### MQTT

关于MQTT说明，请参考 https://mqtt.org/

${clinetId} clinetId 客户id，为替换字符串。<br>

${baseSn} baseSn 是基站编号，为替换字符串。

      
#### 应用程序发布的主题

| 主题 | 功能 |
| --- | --- |
| /\${clientId}/${baseSn}/baseRW | 基站参数设置,查询指令 |
| /\${clientId}/${baseSn}/keyRW | 键盘参数设置,查询指令 |
| /\${clientId}/${baseSn}/answer | 答题业务指令 |
      
#### 应用程序订阅的主题

| 主题 | 功能 |
| --- | --- |
| /\${clientId}/${baseSn}/baseRe | 基站参数数据返回 |
| /\${clientId}/${baseSn}/keyRe| 键盘参数数据返回 |
| /\${clientId}/${baseSn}/answerRe | 答题数据返回 |
| /\${clientId}/${baseSn}/stateCode | 状态码返回 |

# JSON指令说明

协议采用Json数据通信，通信的基本格式如下：



下发：应用程序 ->基站

```json
{
	fun: "" // 功能定义
	baseSn:"2023031402"	//基站SN，字符串
	params： {} //参数对象/数组
	packetTag: "" //数据包标签字符串
}
```

fun：为功能定义，下发命令，要下发的命令函数

baseSn：基站SN列表，字符串数组。可以传递一个基站SN。[此参数请和config.ini 文件的关键字jsonBase的值配合使用]

params：参数，可以为对象或者数组，用于伴随命令下发的数据附属包，详见具体功能定义。

packerTag:
数据标签字符串,用于区别当前指令与其他指令。应用程序发送给基站的，用户可以自定义数据（如果用户无自定义数据，可以为包序号，这样可以区分回复的数据回复的是哪个数据包）。基站回复应用程序时，直接回填应用程序收到的标签数据。

反馈：基站 -> 应用程序

```json
{
	fun: "" //功能定义
	baseSn:"2023031402" //基站SN
	infos: {} //信息对象/数组
	packetTag: "" // 数据包标签字符串，用于区别当前指令与其他指令。基站发送给应用程序的用自增数字标记。基站回复应用程序的，直接回填基站收到的标签。
}
```

fun：同下发描述.
baseSn：同下发描述.
infos:基站反馈给应用程序层的数据。具体详见具体功能定义。
packetTag:数据标签字符串，反馈功能函数的状态为应用程序附带的数据包，如果基站主动发送数据，是一组自增数据。

字段值说明：
反馈infos中的状态字段state，OK表示成功，FAIL表示失败。
反馈infos中的硬件参数字段的值，FAIL表示失败，其他值为成功。
X\~Y:范围内的值特指整数。

## 心跳

应用程序发送心跳，基站回应，用于判断连接状态。

发送：

fun: "heartBeat" //心跳
params:{}//无该值
packetTag:"1"//收到的packetTag,可用于分析通信状态

指令样例：
```json
{
	"fun": "heartBeat",
	"packetTag": "1"
}
```

接收：

fun: "heartBeat" //心跳
infos:{}//无该值
packetTag:"1"//数据包标签

指令样例：

```json
{
	"fun": "heartBeat",
	"packetTag": "1"
}
```

## 基站的连接、断开和复位


注意：在用MQTT操作基站参数时需要关注的发布主题和订阅主题如下：

|**主题**|**格式**|**说明**|
| --- | --- | --- |
| 发布主题 | /\${clientId}/${baseSn}/baseRW | 基站参数设置,查询指令 |
| 订阅主题 | /\${clientId}/${baseSn}/baseRe | 基站参数数据返回 |
| 订阅主题 | /\${clientId}/${baseSn}/stateCode | 状态码返回 |


应用程序与网络基站连接成功后（收到心跳），可发送连接基站指令。收到基站连接成功后就可以与SunVote无线反馈系统（基站、键盘）通讯。

### 连接基站

|**主题**|**格式**|**说明**|
| --- | --- | --- |
| 发布主题 | /\${clientId}/${baseSn}/baseRW | 基站参数设置,查询指令 |
| 订阅主题 | /\${clientId}/${baseSn}/baseRe | 基站参数数据返回 |
| 订阅主题 | /\${clientId}/${baseSn}/stateCode | 状态码返回 |

读取在线基站状态
发送：
fun: "readConnectBase" //连接基站
packetTag:"1" //

指令样例：



```json
{
	"fun": "readConnectBase",
	"packetTag": "1"
}
```

接收：

fun: "connectBase" //连接基站

baseSn:"2023031402" //基站SN
infos: {"state":"OK"} //OK连接成功
packetTag:"1" //收到的packetTag

指令样例：
```json
{
	"fun": "connectBase",
	
	"baseSn":"2023031402",
	"infos": {
		"state": "OK"
	},
	"packetTag": "1"
}
```

基站连接后主动上报，基站上报信息。

接收：

fun: "connectBase" //连接基站

baseSn:"2023031402" //基站SN
infos: {"state":"OK"} //OK连接成功
packetTag:"1" //收到的packetTag

指令样例：
```json
{
	"fun": "connectBase",
	
	"baseSn":"2023031402",
	"infos": {
		"state": "OK"
	},
	"packetTag": "1"
}
```

### 断开基站

|**主题**|**格式**|**说明**|
| --- | --- | --- |
| 发布主题 | /\${clientId}/${baseSn}/baseRW | 基站参数设置,查询指令 |
| 订阅主题 | /\${clientId}/${baseSn}/stateCode | 状态码返回 |

接收：

fun: "disconnectBase" //断开基站

infos: {} //无该值
packetTag:"1"

指令样例：
```json
{
	"fun": "disconnectBase",	
	"baseSn":"2023031402",
	"packetTag": "1"
}
```


### 复位基站

|**主题**|**格式**|**说明**|
| --- | --- | --- |
| 发布主题 | /\${clientId}/${baseSn}/baseRW | 基站参数设置,查询指令 |
| 订阅主题 | /\${clientId}/${baseSn}/stateCode | 状态码返回 |

发送：

fun: "resetBase" //复位基站
baseId:1,
params:{} //无该值

指令样例：

```json
{
	"fun": "resetBase",	
	"baseSn":"2023031402",
	"packetTag": "1"
}
```



注意：B200支持此命令

## 答题

注意：在用MQTT操作答题时需要关注的发布主题和订阅主题如下：

|**主题**|**格式**|**说明**|
| --- | --- | --- |
| 发布主题 | /\${clientId}/${baseSn}/answer | 答题业务指令 |
| 订阅主题 | /\${clientId}/${baseSn}/answerRe | 答题数据返回 |
| 订阅主题 | /\${clientId}/${baseSn}/stateCode | 状态码返回 |


答题流程：

![](img/image5.png)


在开始作答，各类答题都可指定显示标题和开始作答键盘，也可以为空。

顶层对象增加的字段如下：


|**Json字段**|**字段含义**|**赋值及含义**|
| --- | --- | --- |
|keySnList|指定键盘列表|keySn数组，为空表示所有键盘都参与。|



在停止作答时，各类答题都可指定停止作答键盘，也可以为空。

顶层对象增加的字段如下：

|**Json字段**|**字段含义**|**赋值及含义**|
| --- | --- | --- |
|keySnList|指定键盘列表|keySn数组，为空表示所有键盘都参与。|

指令样例：

```json
{
	"keySnList": [{
		"keySn": "1837454011"        
	}, {            
		"keySn": "1837454012"        
	}]
}
```


如果指定了键盘，则会逐个返回指定键盘的接收状态。收到的infos数组对象如下：

|**Json字段**|**字段含义**|**赋值及含义**|
| --- | --- | --- |
|keySn|键盘Sn||          
|state|状态|OK表示成功|



开始作答

发送：

fun: "startXXKeypad" //开始xx作答键盘
baseSn:"2023031402"
params:{} //为空

指令样例：

| 主题 | /\${clientId}/${baseSn}/answer   |
| --- | --- |

```json
{    
	"fun": "startBindKeypad",
	"baseSn":"2023031402",	
	"packetTag": "1"
}
```

接收：

fun: "startBind" //
baseSn:"2023031402"
infos:{"state":"OK"}//返回状态,成功为OK

指令样例：

| 主题 | /\${clientId}/${baseSn}/answerRe |
| --- | --- |

```json
{
	"fun": "startBind",
	"baseSn":"2023031402",
	"infos": {
		"state": "OK"
	},
	"packetTag": "1"
}
```

指定键盘状态返回

指令样例：

| 主题 | /\${clientId}/${baseSn}/answerRe |
| --- | --- |

```json
{
	"fun": "startBind",
	"baseSn":"2023031402",
	"infos": [{
		"keySn": "1837454011",
		"state": "OK"
	}],
	"packetTag": "1"
}
```

键盘在签到启动情况下反馈的数据

指令样例：

| 主题 | /\${clientId}/${baseSn}/answerRe |
| --- | --- |

```json
{
	"fun": "answerBind",
	"baseSn":"2023031402",
	"infos": {
		"time": "2.42",
		"keySn": "1479824643",
		"keyValue": "1234"
	},
	"packetTag": "1"
}
```

发送：

fun: "stopBind" //停止xx作答键盘
baseSn:"2023031402"
params：{} //为空

指令样例：

| 主题 | /\${clientId}/${baseSn}/answer   |
| --- | --- |

```json
{
	"fun": "stopBind",
	"baseSn":"2023031402",
	"packetTag": "1"
}
```


接收：

fun: "stopBind" //停止签到
baseSn:"2023031402"
infos:{"state":"OK"}//返回状态,成功为OK

指令样例：

| 主题 | /\${clientId}/${baseSn}/answerRe |
| --- | --- |

```json
{
	"fun": "stopBind",
	"baseSn":"2023031402",
	"infos": {
		"state": "OK"
	},
	"packetTag": "1"
}
```

### 签到设备

#### 开始签到

发送：

fun: "startBind" //开始签到
params：{}


|**Json字段**| **字段含义** | **赋值及含义**|
| --- | --- | --- |
| bindMode | 签到模式| 1:指定键签到 <br> 2:PIN码签到(默认值) |
| modifyMode     | 修改模式     | 0:不可修改 <br>1:可以修改(默认值)|
| lessMode       | 预留| 0:(默认值）|
| options        | 预留 | 10:(默认值）|
| optionalN      | 可选位数 | 1≤N≤14 |
| keyValue       | 指定按键键值 | 0:未指定[OK键签到] <br>1:1 <br>2:2 <br> 3:3 <br> 4:4 <br> 5:5 <br> 6:6 <br> 7:7 <br> 8:8 <br> 9:9 <br> 10:0 <br> 11:上键  <br> 12:下键 <br> 13:OK  <br> 14:ESC  <br> 15: Menu |
| tipTitle       | 提示标题     | 字符串，长度最多不超过16个字节|


指令样例：

```json
{
	"fun": "startBind",	
	"baseSn":"2023031402",
	"params": {
		"bindMode": "1",
		"lessMode": "0",
		"modifyMode": "1",
		"limitNumber": "1",
		"options": "10",
		"optionalN": "10",
		"keyValue": "0"
	},
	"packetTag": "1"
}
```

接收：

fun: "startBind" //
infos:{"state":"OK"}//返回状态,成功为OK

指令样例：

```json
{
	"fun": "startBind",	
	"baseSn":"2023031402",
	"infos": {
		"state": "OK"
	},
	"packetTag": "1"
}
```

#### 接收签到信息

接收：

fun: "answerBind" //签到返回

infos:{}

|  Json字段|字段含义|赋值及含义|
|---|---|---|
|time|答题时间|单位秒|
|keySn|键盘Sn||
|keyValue|键值|键盘提交的值|

指令样例：

```json
{
	"fun": "answerBind",	
	"baseSn":"2023031402",
	"infos": {
		"time": "2.42",
		"keySn": "1479824643",
		"keyValue": "1234"
	},
	"packetTag": "1"
}
```

#### 停止签到

发送：

fun: "stopBind" //停止签到
params:{} //默认空

指令样例：

```json
{
	"fun": "stopBind",	
	"baseSn":"2023031402",
	"packetTag": "1"
}
```

接收：

fun: "stopBind" //停止签到
infos:{"state":"OK"}//返回状态,成功为OK

指令样例：

```json
{
	"fun": "stopBind",
	"baseSn":"2023031402",	
	"infos": {
		"state": "OK"
	},
	"packetTag": "1"
}
```

#### 支持设备说明

|**基站+键盘 **|**支持/不支持**|**备注**|
| --- | --- | --- |
|B100-2.4G+S6|支持||                 
|B200-2.4G+S6|支持||               
|B200-5.8G+T2|支持||

### 选择题

#### 开始作答

发送：

fun: "startChoices" //开始选择题
params：{}

|Json字段|字段含义|赋值及含义|
|---|---|---|
|optionsMode|选项类别|1:显示字母(默认值) </br>2:显示数字 |
|secrecyMode|保密模式|0:不保密(默认值)</br>1:保密 |
|modifyMode|修改模式|0:不可修改  </br>1:可以修改(默认值) |
|lessMode|迫选模式| 0:可缺选(默认值) </br>1:不可缺选</br>2:允许重复输入</br>3:允许重复输入且不可缺选 |
| options|选项数目|1≤M≤10(默认值4)|
| optionalN|可选项数|1≤N≤M(默认值1)|
| tipTitle|提示标题|字符串，长度最多不超过16个字节|


指令样例：

```json
{
	"fun": "startChoices",	
	"baseSn":"2023031402",
	"params": {
		"optionsMode": "1",
		"secrecyMode": "0",
		"modifyMode": "1",
		"lessMode": "0",
		"options": "4",
		"optionalN": "1"
	},
	"packetTag": "1"
}
```

接收：

fun: "startChoices" //开始选择题
infos:{"state":"OK"}//返回状态,成功为OK

指令样例：

```json
{
	"fun": "startChoices",	
	"baseSn":"2023031402",
	"infos": {
		"state": "OK"
	},
	"packetTag": "1"
}
```


#### 接收作答

接收：

fun: "answerChoices" //选择题作答返回
baseSn:"2023031402"
infos: {}

|Json字段|字段含义|赋值及含义|
|---|---|---|
|time|答题时间|单位秒|
|keySn|键盘Sn||
|keyValue|键值|键盘提交的值|
|keyBattery|电池状态|S6键盘电压值（V）<br>T2键盘电量值（%）|


指令样例：
```json
{
	"fun": "answerChoices",	
	"baseSn":"2023031402",
	"infos": {
		"time": "2.42",
		"keySn": "1479824643",
		"keyValue": "A"
	},
	"packetTag": "1"
}
```

#### 停止作答

发送：

fun: "stopChoices" //停止选择题
params:{} //默认空
指令样例：

```json
{
	"fun": "stopChoices",	
	"baseSn":"2023031402",
	"packetTag": "1"
}
```

接收：

fun: "stopChoices" //停止选择题
baseId: "1"//收到的基站ID
infos:{"state":"OK"}//返回状态,成功为OK

指令样例：

```json
{
	"fun": "stopChoices",	
	"baseSn":"2023031402",
	"infos": {
		"state": "OK"
	},
	"packetTag": "1"
}
```


#### 支持设备说明
|基站+键盘|支持/不支持|备注|
|---|---|---|
|B100-2.4G+S6|支持||
|B200-2.4G+S6|支持||
|B200-5.8G+T2|支持||


### 判断题

#### 开始作答

发送：

fun: "startTrueFalse" //开始判断题
params：{}

|**Json字段**|**字段含义**|**赋值及含义**|
|---|---|---|
| optionsMode    | 选项类别     | 1:True/False 对/错 </br>2:Yes/No 是/否</br> 3:√/×|
| secrecyMode    | 保密模式     | 0:不保密(默认值) </br> 1:保密|
| modifyMode     | 修改模式     | 0:不可修改</br>1:可以修改(默认值)|
| tipTitle       | 提示标题     | 字符串，长度最多不超过16个字节|


指令样例：
```json
{
	"fun": "startTrueFalse",	
	"baseSn":"2023031402",
	"params": {
		"optionsMode": "1",
		"secrecyMode": "0",
		"modifyMode": "1"
	},
	"packetTag": "1"
}
```

接收：

fun: "startTrueFalse" //开始判断题

infos:{"state":"OK"}//返回状态,成功为OK

指令样例：

```json
{
	"fun": "startTrueFalse",	
	"baseSn":"2023031402",
	"infos": {
		"state": "OK"
	},
	"packetTag": "1"
}
```

#### 接收作答 

接收：

fun: "answerTrueFalse" //判断题作答返回

infos: {}

|Json字段|字段含义|赋值及含义|
|---|---|---|
| time|答题时间|单位秒|
|keySn|键盘Sn||
|keyValue|键值|键盘提交的值(1对、2错)|


指令样例：

```json
{
	"fun": "answerTrueFalse",	
	"baseSn":"2023031402",
	"infos": {
		"time": "2.42",
		"keySn": "1479824643",
		"keyValue": "1"
	},
	"packetTag": "1"
}
```

#### 停止作答

发送：

fun: "stopTrueFalse" //停止判断题
params:{} //默认空

指令样例：

```json
{
	"fun": "stopTrueFalse",	
	"baseSn":"2023031402",
	"packetTag": "1"
}
```

接收：

fun: "stopTrueFalse" //停止判断题
baseId: "1"//收到的基站ID
infos:{"state":"OK"}//返回状态,成功为OK

指令样例：

```json
{
	"fun": "stopTrueFalse",	
	"baseSn":"2023031402",
	"infos": {
		"state": "OK"
	},
	"packetTag": "1"
}
```

#### 支持设备说明

|基站+键盘|支持/不支持|备注|
|---|---|---|
|B100-2.4G+S6|支持||
|B200-2.4G+S6|支持||
|B200-5.8G+T2|支持||

### 多题快答

#### 开始作答

发送：

fun: "startMulQuestions" //开始多小题
params：{}


|Json字段|字段含义|赋值及含义|
|---|---|---|
|questionType|题型|0:单选题(默认值)<br>1:判断题|
|secrecyMode| 保密模式| 0:不保密(默认值)<br>1:保密|
|modifyMode| 修改模式| 0:不可修改<br>1:可以修改(默认值)|
|lessMode| 预留|0|
|questionNumber|题目个数|1~16 |
|options|选项数目|1~10 (单选题有效, 默认值4)|
|tipTitle|提示标题|字符串，长度最多不超过16个字节|

指令样例：
```json
{
	"fun": "startMulQuestions",	
	"baseSn":"2023031402",
	"params": {
		"questionType": "0",
		"secrecyMode": "0",
		"modifyMode": "1",
		"lessMode": "0",
		"questionNumber": "10",
		"options": "4"
	},
	"packetTag": "1"
}
```

接收:

fun: "startMulQuestions" //开始多小题

infos:{"state":"OK"}//返回状态,成功为OK

指令样例：

```json
{
	"fun": "startMulQuestions",	
	"baseSn":"2023031402",
	"infos": {
		"state": "OK"
	},
	"packetTag": "1"
}
```

#### 接收作答

接收：

fun: "answerMulQuestions" //多小题作答返回

infos: {}

|Json字段|字段含义|赋值及含义|
|---|---|---|
|time|答题时间|单位秒|
|keySn|键盘Sn||
|keyValue|键值|键盘提交的值|

指令样例：

```json
{
	"fun": "answerMulQuestions",	
	"baseSn":"2023031402",
	"infos": {
		"time": "2.42",
		"keySn": "1479824643",
		"keyValue": "AACDBDADBD"
	},
	"packetTag": "1"
}
```

#### 停止作答

发送：

fun: "stopMulQuestions" //停止多小题
params:{} //默认空

指令样例：

```json
{
	"fun": "stopMulQuestions",	
	"baseSn":"2023031402",
	"packetTag": "1"
}
```

接收：

fun:"stopMulQuestions" //停止多小题
baseId: "1" //收到的基站ID
infos:{"state":"OK"}  //返回状态,成功为OK

指令样例：

```json
{
	"fun": "stopMulQuestions",	
	"baseSn":"2023031402",
	"infos": {
		"state": "OK"
	},
	"packetTag": "1"
}
```

#### 支持设备说明

|基站+键盘|支持/不支持|备注|
|---|---|---|
|B100-2.4G+S6|支持||
|B200-2.4G+S6|支持||
|B200-5.8G+T2|支持||

### 语音题

#### 开始作答

发送：

fun: "startVoice" //开始语音题
params：{}

|Json字段|字段含义|赋值及含义|
|---|---|---|
|recordingMode|录音模式|0:按键录音(默认值)|
|submitTimes|提交次数|0 (0：不限制, 默认值0)|
|recordingTimeLimit|预留|0|
|recordingFormat|预留|0(默认值0)|
|recordAudioFormat|音频格式|0:mp3(默认值)<br>1:实时流|
|buttonMode|按键方式|0:按压录音(默认值)<br>1:单击录音|


指令样例：

```json
{
	"fun": "startVoice",	
	"baseSn":"2023031402",
	"params": {
		"recordingMode": "0",
		"submitTimes": "0",
		"recordingTimeLimit": "0",
		"recordingFormat": "0",
		"recordAudioFormat": "0",
		"buttonMode": "0"
	},
	"packetTag": "1"
}
```

|Json字段|字段含义|赋值及含义|
|---|---|---|
|recordingMode|录音模式|0:按键录音(默认值)|
|submitTimes|提交次数|0 (0：不限制, 默认值0)|
|recordingTimeLimit|录音时长|0~180秒<br>0：不限制|
|recordingFormat|预留|0(默认值0)|
|recordAudioFormat|音频格式|0:mp3(默认值)<br>1:实时流|
|buttonMode|按键方式|0:按压录音(默认值)<br>1:单击录音|
|testMode|自动测试|0:关闭(默认值)<br>1:开启|

自动测试指令样例：

```json
{
	"fun": "startVoice",	
	"baseSn":"2023031402",
	"params": {
		"recordingMode": "0",
		"submitTimes": "0",
		"recordingTimeLimit": "60",
		"recordingFormat": "0",
		"recordAudioFormat": "0",
		"buttonMode": "0",
		"testMode":"1"
	},
	"packetTag": "1"
}
```

接收：

fun: "startVoice" //开始语音题

infos:{"state":"OK"}//返回状态,成功为OK

指令样例：

```json
{
	"fun": "startVoice",	
	"baseSn":"2023031402",
	"infos": {
		"state": "OK"
	},
	"packetTag": "1"
}
```

#### 接收作答

按开始作答时设置的录音格式分为录音文件和实时流两种。

录音文件

接收：

fun: "answerVoiceFile" //录音文件返回

infos: {}

|Json字段|字段含义|赋值及含义|
|---|---|---|
|keySn|键盘Sn||
|filePath|文件路径|录音文件路径|

指令样例：

```json
{
	"fun": "answerVoiceFile",	
	"baseSn":"2023031402",
	"infos": {
		"keySn": "1479749926",
		"filePath": "D:\voice\3_1479749926_196_2023-08-21 16-09-02 530.Mp3"
	},
	"packetTag": "1"
}
```

实时流

接收：

fun: "answerVoiceStream" //语音实时流返回

infos: {}

|Json字段|字段含义|赋值及含义|
|---|---|---|
|keySn|键盘Sn||
|voiceId|回话ID|答题时间内，可重复提交语音，每段语音流加一个回话ID，用于区分作答|
|sampleRate|音频采样率||
|bits|音频采样精度||
|channel|声道数||
|dataIndex|数据包号|1开始|
|data|数据|将原始数据通过Base64编码后得到json中 "data" 字段。应用可通过Base64解码得到原始语音数据。|
|dataLen|数据长度|Base64编码后的字符串长度。应该将 "data" 通过Base64解码后得到原始的数据长度。|
|endFlag|结束标志|默认为0，为1表示结束|

指令样例：


```json
{
	"fun": "answerVoiceStream",	
	"baseSn":"2023031402",
	"infos": {
		"keySn": "1479824643",
		"voiceId": "1",
		"sampleRate": 16000,
		"bits": 16,
		"channel": 1,
		"endFlag": 0,
		"dataIndex": 1,
		"dataLen": 856,
		"data": "AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAEQAAAO7/AAARAAAA7v8AACMAAADK/wAA+gARAI8ANQDoAO7/EQDP/mwD6ADSBBkFgPm+/iH6J/ko/HD8F/8L/u7/rQGU/yMA4f5fAin/MgpDBwADvwRk+yn/fP1e/Jr+DAEAA+gAPAXpBnECgwK5BdEEmwFaA7oF4f63/DX9n/rJ+f75q/tA+5n7fP1q/Y79av1B/nb+Qf70AX0AfQNx/6b8EQBY/Ub9awD0AZUCfgahA4MCBgLV/az+L/5k/o79LwEdAYkBvv5q/X0AHf48BYMCgwKmAgYCdwH0/uL+0P6C/7j/sgApAsr/Kf+U/8T9L/ig+rL3HfVZA6AAsgYSBi8BIwMRABf/pvxB/nH/4v6m/7IAgv9f/7j/3P+gAAsB4gH0AS8BawAAANz/Kf8F/8r/RwAAACMA6ADoAKb/xAC4AgYCLwFBBO4FWQMAA7kFTQUYAnECiQRlASn/4v47/0H+uPxH/UH+L/6O/fn9F//Q/h3+rP5f/zv/8/5N/9z/uP+C/9z/RwBHACMAWQCgAH0ANQA1AEcAEQDK/8r/3P+4/5T/lP+m/5T/gv+C/5T/lP+C/5T/pv+m/w=="
	},
	"packetTag": "1"
}
```

#### 回传分数

收到语音后，可对评测分数回传给键盘，详见[自定义信息]

#### 停止作答

发送：

fun: "stopVoice" //停止语音题
params:{} //默认空，

指令样例：

```json
{
	"fun": "stopVoice",	
	"baseSn":"2023031402",
	"packetTag": "1"
}
```

接收：

fun: "stopVoice" //停止语音题
baseId: "1"//收到的基站ID
infos:{"state":"OK"}//返回状态,成功为OK

指令样例：

```json
{
	"fun": "stopVoice",	
	"baseSn":"2023031402",
	"infos": {
		"state": "OK"
	},
	"packetTag": "1"
}
```

#### 丢包信息

语音结束时基站会发送该次语言的丢包率。

注意：此数据只在语音实时流时有效。

接收：

fun: "voicePacketLossInfo" //丢包信息
baseId:1 	//1~32,连接基站
infos:{} 	//

|Json字段|字段含义|赋值及含义|
|---|---|---|
|keySn|键盘Sn||
|voiceId|回话ID|答题时间内，可重复提交语音，每段语音流加一个回话ID，用于区分作答|
|recordTime|录音延迟时间||
|shouldSendPacketNum|应发数据包数||
|actualSendPacketNum|实发数据包数||
|lossRate|丢包率|百分比|


指令样例：

```json
{
	"fun": "voicePacketLossInfo",	
	"baseSn":"2023031402",
	"infos": {
		"keySn": "1837454011",
		"voiceId": "1",
		"recordTime": "42",
		"shouldSendPacketNum": "56",
		"actualSendPacketNum": "56",
		"lossRate": "0"
	},
	"packetTag": "1"
}
```

#### 支持设备说明

|基站+键盘|支持/不支持|备注|
|---|---|---|
|B200-5.8G+T2|支持|单次录音最长180秒|

### 抢答题

#### 开始作答

发送：

fun: "startRushAnswer" //开始抢答题
params：{}

|Json字段|字段含义|赋值及含义|
|---|---|---|
|rushAnswerMode| 抢答模式|0:普通抢答(默认值)|
|modifyMode|修改模式|0:不可修改<br>1:可以修改(默认值)|



指令样例：
```json
{
	"fun": "startRushAnswer",	
	"baseSn":"2023031402",
	"params": {
		"rushAnswerMode": "0",
		"modifyMode": "1"
	},
	"packetTag": "1"
}
```

接收：

fun: "startRushAnswer" //开始抢答题

infos:{"state":"OK"}//返回状态,成功为OK

指令样例：

```json
{
	"fun": "startRushAnswer",	
	"baseSn":"2023031402",
	"infos": {
		"state": "OK"
	},
	"packetTag": "1"
}
```

#### 接收作答 

接收：

fun: "answerRushAnswer" //抢答题作答返回

infos: {}

|Json字段|字段含义|赋值及含义|
|---|---|---|
|time|答题时间|单位秒|
|keySn|键盘Sn||
|keyValue|键值|键盘提交的值|

指令样例：

```json
{
	"fun": "answerRushAnswer",	
	"baseSn":"2023031402",
	"infos": {
		"time": "1.42",
		"keySn": "1479824643",
		"keyValue": "1"
	},
	"packetTag": "1"
}
```
#### 停止作答

发送：

fun: "stopRushAnswer" //停止抢答题
params:{} //默认空

指令样例：

```json
{
	"fun": "stopRushAnswer",	
	"baseSn":"2023031402",
	"packetTag": "1"
}
```

接收：

fun: "stopRushAnswer" //停止抢答题
baseId: "1"//收到的基站ID
infos:{"state":"OK"}//返回状态,成功为OK

指令样例：

```json
{
	"fun": "stopRushAnswer",	
	"baseSn":"2023031402",
	"infos": {
		"state": "OK"
	},
	"packetTag": "1"
}
```

#### 支持设备说明

|基站+键盘|支持/不支持|备注|
|---|---|---|
|B100-2.4G+S6|支持||
|B200-2.4G+S6|支持||
|B200-5.8G+T2|支持||

### 数字题

#### 开始作答

发送：

fun: "startNumber" //开始数字题
params：{}

|Json字段|字段含义|赋值及含义|
|---|---|---|
|secrecyMode|保密模式|0:不保密(默认值)<br>1:保密|
|modifyMode|修改模式|0:不可修改<br>1:可以修改(默认值)|
|aswOption|按键模式|0:无规则 （S6最多16位，T2最多14位）<br>1:预留<br>2:预留<br>3:带小数位上下限（T2不支持）|
|digits|小数位数|0:没有小数点<br>1:一位小数点<br>2:二位小数点|
|numMin|下限|aswOption=3<br>digits=0 范围：0~65535 <br> digits=1 范围：0~6553 <br> digits=2 范围：0~655|
|numMax|上限|aswOption=3<br>digits=0 范围：0~65535 <br> digits=1 范围：0~6553 <br> digits=2 范围：0~655|
|tipTitle|提示标题|字符串，长度最多不超过16个字节|



指令样例：
```json
{
	"fun": "startNumber",	
	"baseSn":"2023031402",
	"params": {
		"secrecyMode": "0",
		"modifyMode": "1",
		"aswOption": "0",
		"digits": "0",
		"numMin": "0",
		"numMax": "0"
	},
	"packetTag": "1"
}
```

接收：

fun: "startNumber" //开始数字题

infos:{"state":"OK"}//返回状态,成功为OK

指令样例：

```json
{
	"fun": "startNumber",	
	"baseSn":"2023031402",
	"infos": {
		"state": "OK"
	},
	"packetTag": "1"
}
```

#### 接收作答 

接收：

fun: "answerNumber" //数字题作答返回

infos: {}

|Json字段|字段含义|赋值及含义|
|---|---|---|
|time|答题时间|单位秒|
|keySn|键盘Sn||
|keyValue|键值|键盘提交的值|


指令样例：

```json
{
	"fun": "answerNumber",	
	"baseSn":"2023031402",
	"infos": {
		"time": "2.42",
		"keySn": "1479824643",
		"keyValue": "12"
	},
	"packetTag": "1"
}
```

#### 停止作答

发送：

fun: "stopNumber" //停止数字题
params:{} //默认空

指令样例：

```json
{
	"fun": "stopNumber",	
	"baseSn":"2023031402",
	"packetTag": "1"
}
```

接收：

fun: "stopNumber" //停止数字题
infos:{"state":"OK"}//返回状态,成功为OK

指令样例：

```json
{
	"fun": "stopNumber",	
	"baseSn":"2023031402",
	"infos": {
		"state": "OK"
	},
	"packetTag": "1"
}
```

#### 支持设备说明

|基站+键盘|支持/不支持|备注|
|---|---|---|
|B100-2.4G+S6|支持|按键模式（0-无规则 最多16位）|
|B200-2.4G+S6|支持|按键模式（0-无规则 最多16位）|
|B200-5.8G+T2|支持|按键模式（0-无规则 最多14位）<br>按键模式 (3-带小数位上下限)（不支持）|


### 键盘测试

#### 开始测试

发送：

fun: "startKeyPadTest" //开始键盘
params：{}

|Json字段|字段含义|赋值及含义|
|---|---|---|
|mode|测试模式|1-报告状态<br>2-按键模拟|
|keyTime|启动时间|0-60 单位秒 0马上执行 默认为0|
|gapTime|间隔时间|0-60 单位秒 0无效 默认为0|


指令样例：

```json
{
	"fun": "startKeyPadTest",	
	"baseSn":"2023031402",
	"params": {
		"mode": "1",
		"keyTime": "0",
		"gapTime": "0"
	},
	"packetTag": "1"
}
```

#### 接收作答 

接收：

fun: "answerKeyPadTest" //按键测试返回

infos: {}

|Json字段|字段含义|赋值及含义|
|---|---|---|
|Time|答题时间|单位秒|
|keySn|键盘Sn||
|hModel|键盘硬件型号||
|keyValue|键盘键值||
|ver|键盘软件版本||
|volt|键盘电池电量|T2百分比值，S6无效|


指令样例：

```json
{
	"fun": "answerKeyPadTest",	
	"baseSn":"2023031402",
	"infos": {
		"time": "2.42",
		"keySn": "1479824643",
		"hModel": "67",
		"keyValue": "0",
		"ver": "1.0.0",		
		"volt": "12"
	},
	"packetTag": "1"
}
```

#### 停止作答

发送：

fun: "stopKeyPadTest" //停止键盘测试
params:{} //默认空

指令样例：

```json
{
	"fun": "stopKeyPadTest",	
	"baseSn":"2023031402",
	"packetTag": "1"
}
```

接收：

fun: "stopKeyPadTest" //停止键盘测试
baseId: "1"//收到的基站ID
infos:{"state":"OK"}//返回状态,成功为OK

指令样例：

```json
{
	"fun": "stopKeyPadTest",	
	"baseSn":"2023031402",
	"infos": {
		"state": "OK"
	},
	"packetTag": "1"
}
```

#### 支持设备说明

|基站+键盘|支持/不支持|备注|
|---|---|---|
|B100-2.4G+S6|支持|键盘电池电量参数无效|
|B200-2.4G+S6|支持|键盘电池电量参数无效|
|B200-5.8G+T2|支持||


### 多题题型
#### 开始测试

#####  在线测验题型接口

发送：

fun: "startKeyPadMultipleQuestionsTest" //开始在线测验题型
params：{}

| **Json字段** | **字段含义** | **赋值及含义** |
| --- | --- | --- |
| examNo | 测验编号 | 1-9999 <br>注意：1:新的题开始|
| displayMode | 题号显示模式 | 0:不显示开头<br>1:显示“Q”开头<br>2:显示“题”开头|
| questions | 题目详情 | 数组[最大200个单元] |

题目详情数组参数说明

| **Json字段** | **字段含义** | **赋值及含义** |
| --- | --- | --- |
| questionLevel1Symbol | 一级题号 | 1-200 |
| questionLevel2Symbol | 二级题号 | 1-99 [displayMode=0时有效] |
| questionLevel3Symbol | 三级题号 | 1-99 [displayMode=0时有效] |
| questionType | 题目类型 | 1:单选<br>2:多选（排序）<br>3:数字<br>4:判断 |
| option | 选项数目 | 当questionType = 1 有效。<br>当questionType = 2 有效。<br>此项缺省时  默认4;<br>范围：1-10。|


指令样例：一级题型 + 不显示开头
样例目的：一级题型不显示开头，总题数4题
```json
{
	"fun": "startKeyPadMultipleQuestionsTest",	
	"baseSn":"2023031402",
	"params": {
		"examNo": 1,
		"displayMode": 0,
		"questions": [{
			"questionLevel1Symbol": "1",
			"questionType": "1"
		}, {
			"questionLevel1Symbol": "2",
			"questionType": "2",
			"option": "5"
		}, {
			"questionLevel1Symbol": "3",
			"questionType": "3"
		}, {
			"questionLevel1Symbol": "4",
			"questionType": "4"
		}]
	},
	"packetTag": "59"
}
```

指令样例：二级题型 + 不显示开头
样例目的：二级题型不显示开头，总题数4题
```json
{
	"fun": "startKeyPadMultipleQuestionsTest",	
	"baseSn":"2023031402",
	"params": {
		"examNo": 1,
		"displayMode": 0,
		"questions": [{
			"questionLevel1Symbol": "1",
			"questionLevel2Symbol": "1",
			"questionType": "1"
		}, {
			"questionLevel1Symbol": "1",
			"questionLevel2Symbol": "2",
			"questionType": "2",
			"option": "5"
		}, {
			"questionLevel1Symbol": "2",
			"questionLevel2Symbol": "1",
			"questionType": "3"
		}, {
			"questionLevel1Symbol": "2",
			"questionLevel2Symbol": "1",
			"questionType": "4"
		}]
	},
	"packetTag": "59"
}
```

指令样例：三级题型 + 不显示开头
样例目的：三级题型不显示开头，总题数4题
```json
{
	"fun": "startKeyPadMultipleQuestionsTest",	
	"baseSn":"2023031402",
	"params": {
		"examNo": 1,
		"displayMode": 0,
		"questions": [{
			"questionLevel1Symbol": "1",
			"questionLevel2Symbol": "1",
			"questionLevel3Symbol": "1",
			"questionType": "1"
		}, {
			"questionLevel1Symbol": "1",
			"questionLevel2Symbol": "1",
			"questionLevel3Symbol": "2",
			"questionType": "2",
			"option": "5"
		}, {
			"questionLevel1Symbol": "1",
			"questionLevel2Symbol": "1",
			"questionLevel3Symbol": "3",
			"questionType": "3"
		}, {
			"questionLevel1Symbol": "1",
			"questionLevel2Symbol": "1",
			"questionLevel3Symbol": "4",
			"questionType": "4"
		}]
	},
	"packetTag": "59"
}
```

指令样例：一级题型 + 显示“Q”开头
样例目的：一级题型显示“Q”开头，总题数4题
```json
{
	"fun": "startKeyPadMultipleQuestionsTest",	
	"baseSn":"2023031402",
	"params": {
		"examNo": 1,
		"displayMode": 1,
		"questions": [{
			"questionLevel1Symbol": "1",
			"questionType": "1"
		}, {
			"questionLevel1Symbol": "2",
			"questionType": "2",
			"option": "5"
		}, {
			"questionLevel1Symbol": "3",
			"questionType": "3"
		}, {
			"questionLevel1Symbol": "4",
			"questionType": "4"
		}]
	},
	"packetTag": "59"
}
```
指令样例：一级题型 + 显示“题”开头
样例目的：一级题型显示“题”开头，总题数4题
```json
{
	"fun": "startKeyPadMultipleQuestionsTest",	
	"baseSn":"2023031402",
	"params": {
		"examNo": 1,
		"displayMode": 2,
		"questions": [{
			"questionLevel1Symbol": "1",
			"questionType": "1"
		}, {
			"questionLevel1Symbol": "2",
			"questionType": "2",
			"option": "5"
		}, {
			"questionLevel1Symbol": "3",
			"questionType": "3"
		}, {
			"questionLevel1Symbol": "4",
			"questionType": "4"
		}]
	},
	"packetTag": "59"
}
```
接收：

fun: "keyPadMultipleQuestionsTest" //
baseId: "1"//收到的基站ID
infos:{"state":"OK"}//返回状态,成功为OK

指令样例：

```json
{
	"fun": "keyPadMultipleQuestionsTest",	
	"baseSn":"2023031402",
	"infos": {
		"state": "OK"
	},
	"packetTag": "59"
}
```

##### 多科作业题型接口

发送：

fun: "startKeyPadMultipleQuestionsCourse" //开始多科作业题型
params：{}

| **Json字段** | **字段含义** | **赋值及含义** |
| --- | --- | --- |
| examNo | 测验编号 | 1-9999 <br>注意：1:新的题开始|
| displayMode | 题号显示模式 | 0:不显示开头<br>1:显示“Q”开头<br>2:显示“题”开头|
| questions | 题目详情 | 数组[最大200个单元] |

题目详情数组参数说明

| **Json字段** | **字段含义** | **赋值及含义** |
| --- | --- | --- |
| questionLevel1Symbol | 一级题号 | 1-200 |
| questionLevel2Symbol | 二级题号 | 1-99 [displayMode=0时有效] |
| course | 科目 | 1:语文<br>2:数学<br>3:英语<br>4:政治<br>5:历史<br>6:地理<br>7:生物<br>8:物理<br>9:化学 |
| questionType | 题目类型 | 1:单选<br>2:多选（排序）<br>3:数字<br>4:判断 |
| option | 选项数目 |  当questionType = 1 有效。<br>当questionType = 2 有效。<br>此项缺省时  默认4;<br>范围：1-10。|

指令样例：带科目 + 二级题型 + 不显示开头
样例目的：语文2题+数学2题+英语2题
```json
{
	"fun": "startKeyPadMultipleQuestionsCourse",	
	"baseSn":"2023031402",
	"params": {
		"examNo": 1,
		"displayMode": 0,
		"questions": [{
			"questionLevel1Symbol": "1",
			"questionLevel2Symbol": "1",
			"course": "1",
			"questionType": "1"
		}, {
			"questionLevel1Symbol": "1",
			"questionLevel2Symbol": "2",
			"course": "1",
			"questionType": "2",
			"option": "5"
		}, {
			"questionLevel1Symbol": "1",
			"questionLevel2Symbol": "1",
			"course": "2",
			"questionType": "3"
		}, {
			"questionLevel1Symbol": "1",
			"questionLevel2Symbol": "2",
			"course": "2",
			"questionType": "4"
		}, {
			"questionLevel1Symbol": "1",
			"questionLevel2Symbol": "1",
			"course": "3",
			"questionType": "3"
		}, {
			"questionLevel1Symbol": "1",
			"questionLevel2Symbol": "2",
			"course": "3",
			"questionType": "4"
		}]
	},
	"packetTag": "59"
}
```

指令样例：带科目 + 一级题型 + 不显示开头
样例目的：语文4题
```json
{
	"fun": "startKeyPadMultipleQuestionsCourse",	
	"baseSn":"2023031402",
	"params": {
		"examNo": 1,
		"displayMode": 0,
		"questions": [{
			"questionLevel1Symbol": "1",
			"course": "1",
			"questionType": "1"
		}, {
			"questionLevel1Symbol": "2",
			"course": "1",
			"questionType": "2",
			"option": "5"
		}, {
			"questionLevel1Symbol": "3",
			"course": "1",
			"questionType": "3"
		}, {
			"questionLevel1Symbol": "4",
			"course": "1",
			"questionType": "4"
		}]
	},
	"packetTag": "59"
}
```

指令样例：带科目 + 一级题型 + 显示“Q”开头
样例目的：语文4题
```json
{
	"fun": "startKeyPadMultipleQuestionsCourse",	
	"baseSn":"2023031402",
	"params": {
		"examNo": 1,
		"displayMode": 1,
		"questions": [{
			"questionLevel1Symbol": "1",
			"course": "1",
			"questionType": "1"
		}, {
			"questionLevel1Symbol": "2",
			"course": "1",
			"questionType": "2",
			"option": "5"
		}, {
			"questionLevel1Symbol": "3",
			"course": "1",
			"questionType": "3"
		}, {
			"questionLevel1Symbol": "4",
			"course": "1",
			"questionType": "4"
		}]
	},
	"packetTag": "59"
}
```

指令样例：带科目 + 一级题型 + 显示“题”开头
样例目的：语文4题
```json
{
	"fun": "startKeyPadMultipleQuestionsCourse",	
	"baseSn":"2023031402",
	"params": {
		"examNo": 1,
		"displayMode": 2,
		"questions": [{
			"questionLevel1Symbol": "1",
			"course": "1",
			"questionType": "1"
		}, {
			"questionLevel1Symbol": "2",
			"course": "1",
			"questionType": "2",
			"option": "5"
		}, {
			"questionLevel1Symbol": "3",
			"course": "1",
			"questionType": "3"
		}, {
			"questionLevel1Symbol": "4",
			"course": "1",
			"questionType": "4"
		}]
	},
	"packetTag": "59"
}
```

接收：

fun: "keyPadMultipleQuestionsCourse" //
baseId: "1"//收到的基站ID
infos:{"state":"OK"}//返回状态,成功为OK

指令样例：

```json
{
	"fun": "keyPadMultipleQuestionsCourse",	
	"baseSn":"2023031402",
	"infos": {
		"state": "OK"
	},
	"packetTag": "59"
}
```

##### 主观题分数输入接口
发送：

fun: "startKeyPadMultipleQuestionsSubjective" //开始主观题分数输入
params：{}

| **Json字段** | **字段含义** | **赋值及含义** |
| --- | --- | --- |
| examNo | 测验编号 | 1-9999 <br>注意：1:新的题开始 |
| questions | 题目详情 | 数组[最大200个单元] |

题目详情数组参数说明

| **Json字段** | **字段含义** | **赋值及含义** |
| --- | --- | --- |
| questionLevel1Symbol | 一级题号 | 1-200 |
| toplimit | 数字上限 | 1-600 |
| decimal | 小数位数 | 0:无效小数<br>1:一位小数<br>2:二位小数 <br>此项缺省时默认是0。|

```json
{
	"fun": "startKeyPadMultipleQuestionsSubjective",	
	"baseSn":"2023031402",
	"params": {
		"examNo": 1,
		"questions": [{
			"questionLevel1Symbol": "1",
			"toplimit": "100",
			"decimal": "0"
		}, {
			"questionLevel1Symbol": "2",
			"toplimit": "100",
			"decimal": "1"
		}, {
			"questionLevel1Symbol": "3",
			"toplimit": "100",
			"decimal": "2"
		}, {
			"questionLevel1Symbol": "4",
			"toplimit": "100"
		}]
	},
	"packetTag": "59"
}
```

接收：

fun: "KeyPadMultipleQuestionsSubjective" //
baseId: "1"//收到的基站ID
infos:{"state":"OK"}//返回状态,成功为OK

指令样例：

```json
{
	"fun": "KeyPadMultipleQuestionsSubjective",	
	"baseSn":"2023031402",
	"infos": {
		"state": "OK"
	},
	"packetTag": "59"
}
```



#### 接收作答 

接收：

fun: "answerKeyPadMultipleQuestions" 	//多题题型返回

baseId: "1"		//接收到指令的基站ID

infos: {}

| **Json字段** | **字段含义** | **赋值及含义** |
| --- | --- | --- |
| Time | 答题时间 | 单位秒，20分钟内有效 |
| keySn | 键盘Sn | |
| Seq | 题序号 | |
| keyValue | 键值 |键盘提交的值 |



指令样例：
```json
{
	"fun": "answerKeyPadMultipleQuestions",	
	"baseSn":"2023031402",
	"infos": {
		"time": "5.42",
		"keySn": "1479824643",
		"seq": "1",
		"keyValue": "12"
	},

	"packetTag": "1"
}
```

#### 退出作答

发送：

fun: "stopKeyPadMultipleQuestions" //停止多题题型

params:{} //默认空

指令样例：

```json
{
	"fun": "stopKeyPadMultipleQuestions",	
	"baseSn":"2023031402",
	"packetTag": "1"
}
```

接收：

fun: "stopKeyPadMultipleQuestions" //停止键盘测试

baseId: "1"//收到的基站ID

infos:{"state":"OK"}//返回状态,成功为OK

指令样例：

```json
{
	"fun": "stopKeyPadMultipleQuestions",	
	"baseSn":"2023031402",
	"infos": {
		"state": "OK"
	},
	"packetTag": "1"
}
```

#### 暂停作答

发送：

fun: "pauseKeyPadMultipleQuestions" //暂停多提题型

baseId: "1"//收到的基站ID

params:{} //默认空

指令样例：

```json
{
	"fun": "pauseKeyPadMultipleQuestions",	
	"baseSn":"2023031402",
	"packetTag": "1"
}
```


接收：

fun: "pauseKeyPadMultipleQuestions" //暂停键盘测试

baseId: "1"//收到的基站ID

infos:{"state":"OK"}//返回状态,成功为OK

指令样例：

```json
{
	"fun": "pauseKeyPadMultipleQuestions",	
	"baseSn":"2023031402",
	"infos": {
		"state": "OK"
	},
	"packetTag": "1"
}
```

#### 继续测试


#####  在线测验题型接口

发送：

fun: "continueKeyPadMultipleQuestionsTest" //继续在线测验题型
params：{}

| **Json字段** | **字段含义** | **赋值及含义** |
| --- | --- | --- |
| examNo | 测验编号 | 1-9999 |
| displayMode | 题号显示模式 | 0:不显示开头<br>1:显示“Q”开头<br>2:显示“题”开头|
| questions | 题目详情 | 数组[最大200个单元] |

题目详情数组参数说明

| **Json字段** | **字段含义** | **赋值及含义** |
| --- | --- | --- |
| questionLevel1Symbol | 一级题号 | 1-200 |
| questionLevel2Symbol | 二级题号 | 1-99 [displayMode=0时有效] |
| questionLevel3Symbol | 三级题号 | 1-99 [displayMode=0时有效] |
| questionType | 题目类型 | 1:单选<br>2:多选（排序）<br>3:数字<br>4:判断 |
| option | 选项数目 | 当questionType = 1 有效。<br>当questionType = 2 有效。<br>此项缺省时  默认4;<br>范围：1-10。|


指令样例：一级题型 + 不显示开头
```json
{
	"fun": "continueKeyPadMultipleQuestionsTest",	
	"baseSn":"2023031402",
	"params": {
		"examNo": 1,
		"displayMode": 0,
		"questions": [{
			"questionLevel1Symbol": "1",
			"questionType": "1"
		}, {
			"questionLevel1Symbol": "2",
			"questionType": "2",
			"option": "5"
		}, {
			"questionLevel1Symbol": "3",
			"questionType": "3"
		}, {
			"questionLevel1Symbol": "4",
			"questionType": "4"
		}]
	},
	"packetTag": "59"
}
```

指令样例：二级题型 + 不显示开头
```json
{
	"fun": "continueKeyPadMultipleQuestionsTest",	
	"baseSn":"2023031402",
	"params": {
		"examNo": 1,
		"displayMode": 0,
		"questions": [{
			"questionLevel1Symbol": "1",
			"questionLevel2Symbol": "1",
			"questionType": "1"
		}, {
			"questionLevel1Symbol": "1",
			"questionLevel2Symbol": "2",
			"questionType": "2",
			"option": "5"
		}, {
			"questionLevel1Symbol": "1",
			"questionLevel2Symbol": "3",
			"questionType": "3"
		}, {
			"questionLevel1Symbol": "1",
			"questionLevel2Symbol": "4",
			"questionType": "4"
		}]
	},
	"packetTag": "59"
}
```

指令样例：三级题型 + 不显示开头
```json
{
	"fun": "continueKeyPadMultipleQuestionsTest",	
	"baseSn":"2023031402",
	"params": {
		"examNo": 1,
		"displayMode": 0,
		"questions": [{
			"questionLevel1Symbol": "1",
			"questionLevel2Symbol": "1",
			"questionLevel3Symbol": "1",
			"questionType": "1"
		}, {
			"questionLevel1Symbol": "1",
			"questionLevel2Symbol": "1",
			"questionLevel3Symbol": "2",
			"questionType": "2",
			"option": "5"
		}, {
			"questionLevel1Symbol": "1",
			"questionLevel2Symbol": "1",
			"questionLevel3Symbol": "3",
			"questionType": "3"
		}, {
			"questionLevel1Symbol": "1",
			"questionLevel2Symbol": "1",
			"questionLevel3Symbol": "4",
			"questionType": "4"
		}]
	},
	"packetTag": "59"
}
```

指令样例：一级题型 + 显示“Q”开头
```json
{
	"fun": "continueKeyPadMultipleQuestionsTest",	
	"baseSn":"2023031402",
	"params": {
		"examNo": 1,
		"displayMode": 1,
		"questions": [{
			"questionLevel1Symbol": "1",
			"questionType": "1"
		}, {
			"questionLevel1Symbol": "2",
			"questionType": "2",
			"option": "5"
		}, {
			"questionLevel1Symbol": "3",
			"questionType": "3"
		}, {
			"questionLevel1Symbol": "4",
			"questionType": "4"
		}]
	},
	"packetTag": "59"
}
```

指令样例：一级题型 + 显示“题”开头
```json
{
	"fun": "continueKeyPadMultipleQuestionsTest",	
	"baseSn":"2023031402",
	"params": {
		"examNo": 1,
		"displayMode": 2,
		"questions": [{
			"questionLevel1Symbol": "1",
			"questionType": "1"
		}, {
			"questionLevel1Symbol": "2",
			"questionType": "2",
			"option": "5"
		}, {
			"questionLevel1Symbol": "3",
			"questionType": "3"
		}, {
			"questionLevel1Symbol": "4",
			"questionType": "4"
		}]
	},
	"packetTag": "59"
}
```
接收：

fun: "keyPadMultipleQuestionsTest" //
baseId: "1"//收到的基站ID
infos:{"state":"OK"}//返回状态,成功为OK

指令样例：

```json
{
	"fun": "keyPadMultipleQuestionsTest",	
	"baseSn":"2023031402",
	"infos": {
		"state": "OK"
	},
	"packetTag": "59"
}
```

##### 多科作业题型接口

发送：

fun: "continueKeyPadMultipleQuestionsCourse" //继续多科作业题型
params：{}

| **Json字段** | **字段含义** | **赋值及含义** |
| --- | --- | --- |
| examNo | 测验编号 | 1-9999 |
| displayMode | 题号显示模式 | 0:不显示开头<br>1:显示“Q”开头<br>2:显示“题”开头|
| questions | 题目详情 | 数组[最大200个单元] |

题目详情数组参数说明

| **Json字段** | **字段含义** | **赋值及含义** |
| --- | --- | --- |
| questionLevel1Symbol | 一级题号 | 1-200 |
| questionLevel2Symbol | 二级题号 | 1-99 [displayMode=0时有效] |
| course | 科目 | 1:语文<br>2:数学<br>3:英语<br>4:政治<br>5:历史<br>6:地理<br>7:生物<br>8:物理<br>9:化学 |
| questionType | 题目类型 | 1:单选<br>2:多选（排序）<br>3:数字<br>4:判断 |
| option | 选项数目 |  当questionType = 1 有效。<br>当questionType = 2 有效。<br>此项缺省时  默认4;<br>范围：1-10。|

指令样例：带科目 + 二级题型 + 不显示开头
样例目的：语文2题+数学2题+英语2题
```json
{
	"fun": "continueKeyPadMultipleQuestionsCourse",	
	"baseSn":"2023031402",
	"params": {
		"examNo": 1,
		"displayMode": 0,
		"questions": [{
			"questionLevel1Symbol": "1",
			"questionLevel2Symbol": "1",
			"course": "1",
			"questionType": "1"
		}, {
			"questionLevel1Symbol": "1",
			"questionLevel2Symbol": "2",
			"course": "1",
			"questionType": "2",
			"option": "5"
		}, {
			"questionLevel1Symbol": "1",
			"questionLevel2Symbol": "1",
			"course": "2",
			"questionType": "3"
		}, {
			"questionLevel1Symbol": "1",
			"questionLevel2Symbol": "2",
			"course": "2",
			"questionType": "4"
		}, {
			"questionLevel1Symbol": "1",
			"questionLevel2Symbol": "1",
			"course": "3",
			"questionType": "3"
		}, {
			"questionLevel1Symbol": "1",
			"questionLevel2Symbol": "2",
			"course": "3",
			"questionType": "4"
		}]
	},
	"packetTag": "59"
}
```



指令样例：带科目 + 一级题型 + 不显示开头
样例目的：语文4题
```json
{
	"fun": "continueKeyPadMultipleQuestionsCourse",	
	"baseSn":"2023031402",
	"params": {
		"examNo": 1,
		"displayMode": 0,
		"questions": [{
			"questionLevel1Symbol": "1",
			"course": "1",
			"questionType": "1"
		}, {
			"questionLevel1Symbol": "2",
			"course": "1",
			"questionType": "2",
			"option": "5"
		}, {
			"questionLevel1Symbol": "3",
			"course": "1",
			"questionType": "3"
		}, {
			"questionLevel1Symbol": "4",
			"course": "1",
			"questionType": "4"
		}]
	},
	"packetTag": "59"
}
```

指令样例：带科目 + 一级题型 + 显示“Q”开头
样例目的：语文4题
```json
{
	"fun": "continueKeyPadMultipleQuestionsCourse",	
	"baseSn":"2023031402",
	"params": {
		"examNo": 1,
		"displayMode": 1,
		"questions": [{
			"questionLevel1Symbol": "1",
			"course": "1",
			"questionType": "1"
		}, {
			"questionLevel1Symbol": "2",
			"course": "1",
			"questionType": "2",
			"option": "5"
		}, {
			"questionLevel1Symbol": "3",
			"course": "1",
			"questionType": "3"
		}, {
			"questionLevel1Symbol": "4",
			"course": "1",
			"questionType": "4"
		}]
	},
	"packetTag": "59"
}
```

指令样例：带科目 + 一级题型 + 显示“题”开头
样例目的：语文4题
```json
{
	"fun": "continueKeyPadMultipleQuestionsCourse",	
	"baseSn":"2023031402",
	"params": {
		"examNo": 1,
		"displayMode": 2,
		"questions": [{
			"questionLevel1Symbol": "1",
			"course": "1",
			"questionType": "1"
		}, {
			"questionLevel1Symbol": "2",
			"course": "1",
			"questionType": "2",
			"option": "5"
		}, {
			"questionLevel1Symbol": "3",
			"course": "1",
			"questionType": "3"
		}, {
			"questionLevel1Symbol": "4",
			"course": "1",
			"questionType": "4"
		}]
	},
	"packetTag": "59"
}
```

接收：

fun: "keyPadMultipleQuestionsCourse" //
baseId: "1"//收到的基站ID
infos:{"state":"OK"}//返回状态,成功为OK

指令样例：

```json
{
	"fun": "keyPadMultipleQuestionsCourse",	
	"baseSn":"2023031402",
	"infos": {
		"state": "OK"
	},
	"packetTag": "59"
}
```

##### 主观题分数输入接口
发送：

fun: "continueKeyPadMultipleQuestionsSubjective" //继续主观题分数输入
params：{}

| **Json字段** | **字段含义** | **赋值及含义** |
| --- | --- | --- |
| examNo | 测验编号 | 1-9999 |
| questions | 题目详情 | 数组[最大200个单元] |

题目详情数组参数说明

| **Json字段** | **字段含义** | **赋值及含义** |
| --- | --- | --- |
| questionLevel1Symbol | 一级题号 | 1-200 |
| toplimit | 数字上限 | 1-600 |
| decimal | 小数位数 | 0:无效小数<br>1:一位小数<br>2:二位小数 <br>此项缺省时默认是0。|

```json
{
	"fun": "continueKeyPadMultipleQuestionsSubjective",	
	"baseSn":"2023031402",
	"params": {
		"examNo": 1,
		"questions": [{
			"questionLevel1Symbol": "1",
			"toplimit": "100",
			"decimal": "0"
		}, {
			"questionLevel1Symbol": "2",
			"toplimit": "100",
			"decimal": "1"
		}, {
			"questionLevel1Symbol": "3",
			"toplimit": "100",
			"decimal": "2"
		}, {
			"questionLevel1Symbol": "4",
			"toplimit": "100"
		}]
	},
	"packetTag": "59"
}
```

接收：

fun: "keyPadMultipleQuestionsSubjective" //
baseId: "1"//收到的基站ID
infos:{"state":"OK"}//返回状态,成功为OK

指令样例：

```json
{
	"fun": "keyPadMultipleQuestionsSubjective",	
	"baseSn":"2023031402",
	"infos": {
		"state": "OK"
	},
	"packetTag": "59"
}
```

#### 指定键盘转移作答内容
注意：此接口一次只能对一只键盘进行操作。

发送：

fun: "copyKeyPadMultipleQuestions" //转移键盘作答内容
params:{} //

| **Json字段** | **字段含义** | **赋值及含义** |
| --- | --- | --- |
| baseId | 键盘所连基站ID | 1-32 |
| keySn | 目标键盘SN |  |
| id | 题目编号 | 1-200 |
| questionType | 题目类型 | 1:单选<br>2:多选（排序）<br>3:数字<br>4:判断 |
| value | 题目答案 |字符串16字节   |


指令样例：

```json
{
	"fun": "copyKeyPadMultipleQuestions",	
	"baseSn":"2023031402",
	"params": {
		"keySn": "0007831203",
		"questions": [{
			"id": "1",
			"questionType": "1",
			"value": "A"
		}, {
			"id": "2",
			"questionType": "2",
			"value": "AB"
		}]
	},
	"packetTag": "19"
}
```

接收：

fun: "copyKeyPadMultipleQuestions" //
baseId: "1"//收到的基站ID
infos:{"state":"OK"}//返回状态,成功为OK

指令样例：

```json
{
	"fun": "copyKeyPadMultipleQuestions",	
	"baseSn":"2023031402",
	"infos": {
		"state": "OK"
	},
	"packetTag": "1"
}
```

#### 向键盘广播正确答案

发送：

fun: "okKeyPadMultipleQuestions" //向键盘广播正确答案
baseId: "1"//收到的基站ID
params:{} //默认空

| **Json字段** | **字段含义** | **赋值及含义** |
| --- | --- | --- |
| baseId | 基站ID | 1-32 |
| id | 题目编号 | 1-200 |
| questionType | 题目类型 | 1:单选<br>2:多选（排序）<br>3:数字<br>4:判断 |
| value | 题目答案 |字符串16字节   |


指令样例：
```json
{
	"fun": "okKeyPadMultipleQuestions",	
	"baseSn":"2023031402",
	"params": [{
		"id": "1",
		"questionType": "1",
		"value": "A"
	}, {
		"id": "2",
		"questionType": "2",
		"value": "AB"
	}],
	"packetTag": "20"
}

```

接收：

fun: "okKeyPadMultipleQuestions" //
baseId: "1"//收到的基站ID
infos:{"state":"OK"}//返回状态,成功为OK

指令样例：
```json
{
	"fun": "okKeyPadMultipleQuestions",	
	"baseSn":"2023031402",
	"infos": {
		"state": "OK"
	},
	"packetTag": "1"
}
```

#### 支持设备说明

| **基站+键盘** | **支持** | **备注** |
| --- | --- | --- |
| B100-2.4G+S6 | 支持 |  |
| B200-2.4G+S6 | 支持 |  |


### 填空题

#### 开始作答

发送：

fun: "startTextAnswer" //开始填空题
params：{}

| **Json字段** | **字段含义** | **赋值及含义** |
| --- | --- | --- |
| optionsMode | 填空类型 | 1:任意输入(默认值) |
| modifyMode | 预留 | 1: (默认值) |
| secrecyMode | 预留 | 0: (默认值) |


指令样例：

```json
{
	"fun": "startTextAnswer",	
	"baseSn":"2023031402",
	"params": {
		"optionsMode": "1",
		"modifyMode": "1",
		"secrecyMode": "0"
	},
	"packetTag": "1"
}
```

接收：

fun: "startTextAnswer " //开始填空题
baseId: "1"				//接收到指令的基站ID
infos:{"state":"OK"}	//返回状态,成功为OK

指令样例：

```json
{
	"fun": "startTextAnswer",	
	"baseSn":"2023031402",
	"infos": {
		"state": "OK"
	},
	"packetTag": "1"
}
```

#### 接收作答 

接收：

fun: "answerTextAnswer" 	//填空题作答返回
baseId: "1"				//接收到指令的基站ID
infos: {}

| **Json字段** | **字段含义** | **赋值及含义** |
| --- | --- | --- |
| keySn | 键盘Sn |  |
| keyValue | 键值 | 字符串 |


指令样例：

```json
{
	"fun": "answerTextAnswer",	
	"baseSn":"2023031402",
	"infos": {
		"keySn": "1479824643",
		"keyValue": "abcdef"
	},
	"packetTag": "1"
}
```

#### 停止作答

发送：

fun: "stopTextAnswer" //停止填空题
params:{} //默认空

指令样例：
```json
{
	"fun": "stopTextAnswer",	
	"baseSn":"2023031402",
	"packetTag": "1"
}
```

接收：

fun: "stopTextAnswer" //停止填空题
baseId: "1"//收到的基站ID
infos:{"state":"OK"}//返回状态,成功为OK

指令样例：
```json
{
	"fun": "stopTextAnswer",	
	"baseSn":"2023031402",
	"infos": {
		"state": "OK"
	},
	"packetTag": "1"
}
```

#### 支持设备说明

| **基站+键盘** | **支持** | **备注** |
| --- | --- | --- |
| B100-2.4G+S6 | 支持 |  |
| B200-2.4G+S6 | 支持 |  | 

### 自由题型

#### 开始作答

发送：

fun: "startFreeQuestion" //开始填空题
params：{}

指令样例：

```json
{
	"fun": "startFreeQuestion",	
	"baseSn":"2023031402",
	"params": {},
	"packetTag": "1"
}
```

接收：

fun: "startFreeQuestion " //开始自由题型
baseId: "1"				//接收到指令的基站ID
infos:{"state":"OK"}	//返回状态,成功为OK

指令样例：

```json
{
	"fun": "startFreeQuestion",	
	"baseSn":"2023031402",
	"infos": {
		"state": "OK"
	},
	"packetTag": "1"
}
```

#### 接收作答 

接收：
接收作答数据有键盘提交决定分为：选择题、判断题和数字题三个类型

选择题：
fun: "answerChoices" //自由题型作答返回

infos: {}


| **Json字段** | **字段含义** | **赋值及含义** |
| --- | --- | --- |
| keySn | 键盘Sn | |
| keyValue | 键值 | ABCD/1234 |


指令样例：

```json
{
	"fun": "answerChoices",	
	"baseSn":"2023031402",
	"infos": {
		"keySn": "1479824643",
		"keyValue": "ABC"
	},
	"packetTag": "0"
}
```

判断题：
fun: "answerTrueFalse" //自由题型作答返回

infos: {} 

| **Json字段** | **字段含义** | **赋值及含义** |
| --- | --- | --- |
| keySn | 键盘Sn | |
| keyValue | 键值 |1~2|

指令样例：

```json
{
	"fun": "answerTrueFalse",	
	"baseSn":"2023031402",
	"infos": {
		"keySn": "1479824643",
		"keyValue": "1"
	},
	"packetTag": "0"
}
```
数字题：
fun: "answerNumber" //自由题型作答返回

infos: {} 

| **Json字段** | **字段含义** | **赋值及含义** |
| --- | --- | --- |
| keySn | 键盘Sn | |
| keyValue | 键值 |键盘提交的值|

指令样例：

```json
{
	"fun": "answerNumber",	
	"baseSn":"2023031402",
	"infos": {
		"keySn": "1479824643",
		"keyValue": "99.99"
	},
	"packetTag": "0"
}
```



#### 停止作答

发送：
fun: "stopFreeQuestion" //停止自由题型
params:{} //默认空


指令样例：
```json
{
	"fun": "stopFreeQuestion",	
	"baseSn":"2023031402",
	"packetTag": "1"
}
```

接收：

fun: "stopFreeQuestion" //停止自由题型
baseId: "1"//收到的基站ID
infos:{"state":"OK"}//返回状态,成功为OK

指令样例：
```json
{
	"fun": "stopFreeQuestion",	
	"baseSn":"2023031402",
	"infos": {
		"state": "OK"
	},
	"packetTag": "1"
}
```

#### 支持设备说明

| **基站+键盘** | **支持** | **备注** |
| --- | --- | --- |
| B200-2.4G+S6 | 支持 |需要指定键盘支持| 

### 数字选举

```json
{
	"fun": "startKeyPadCustomQuestions",	
	"baseSn":"2023031402",
	"params": {
		"titleTable": ["数字表决1", "数字表决2", "数字表决3"],
		"optionTable": [
			["1", "2", "3", "4", "5", "6", "7", "8", "9", "10"]
		],
		"ruleTable": [{
			"ruleType": "2",
			"mode": "0",
			"modifyMode": "1",
			"secrecyMode": "0",
			"lessMode": "0",
			"repeat": "0",
			"sort": "1",
			"max": "4",
			"min": "1",
			"retain": ["777", "999"],
			"range": [{
				"rangeStart": "1",
				"rangeEnd": "100"
			}, {
				"rangeStart": "101",
				"rangeEnd": "200"
			}, {
				"rangeStart": "201",
				"rangeEnd": "300"
			}]
		}],
		"permissionTable": [{
				"permission": "2",
				"keySnList": ["1479824643", "1479824644", "1479824645", "1479824646"]
			},
			{
				"permission": "1",
				"keySnList": ["1479824643", "1479824644", "1479824645", "1479824646"]
			}
		],
		"configTable": [{
				"number": "1",
				"titleID": "1",
				"optionID": "1",
				"ruleID": "1",
				"permissionID": "0"
			},

			{
				"number": "2",
				"titleID": "2",
				"optionID": "1",
				"ruleID": "1",
				"permissionID": "0"
			},
			{
				"number": "3",
				"titleID": "3",
				"optionID": "1",
				"ruleID": "1",
				"permissionID": "0"
			}
		]
	},
	"packetTag": "59"
}
```

### 自定义题型
#### 标准题型

##### 开始测试

发送：

fun: "startKeyPadCustomQuestions" //开始
params：{}

| **Json字段** | **字段含义** | **赋值及含义** |
| --- | --- | --- |
|titleTable| 题目表 |数组[字符串]| 
| optionTable | 选项表 |数组<br>"A，B，C，D" [默认]<br>" 1，2，3，4 "<br>" 对，错 "<br>" √，× "<br>" 同意，反对，弃权 "| 
|ruleTable| 规则表 |数组[内容请参考“规则字段解释”]| 
|permissionTable| 许可权限表 |数组| 
|configTable| 配置表 |数组| 

许可权限表结构表说明
| **Json字段** | **字段含义** | **赋值及含义** |
| --- | --- | --- |
|permission| 许可权限 |0:无[默认]<br>1: 允许<br>2: 禁止| 
|KeySnList| 键盘列表 |数组<br>"1479824643"<br>"1479824644"<br>"1479824645"<br>"1479824646"| 


配置表结构表说明
| **Json字段** | **字段含义** | **赋值及含义** |
| --- | --- | --- |
|ruleType| 题编号 |1-200| 
|titleID|题目表ID|1-200| 
|optionID|选项表ID|1-200| 
|ruleID|规则表ID|1-200| 
|permissionID|许可权限表ID|1-200| 

规则字段解释：
规则类型1：

| **Json字段** | **字段含义** | **赋值及含义** |
| --- | --- | --- |
|ruleType| 规则类型 |1| 
|mode|模式|0: 默认（单选选择）<br>1: 纯数字组合 ，包含（上下键做负号与点号）<br>2: 填空自由组合，键盘自己实现输入方式<br>3: 多小题显示格式<br>4: 批次表决、批次评议<br>5: 批次评分<br>6: 名单选举<br>7: 累计投票、股权投票| 
|modifyMode|修改模式|0:不可修改<br> 1:可修改，默认| 
|secrecyMode|保密模式|0:不保密，默认<br>  1:保密| 
|lessMode|迫选模式|0:不迫选，默认<br> 1:迫选| 
|repeat|重复模式|0:不限制，默认<br> 1:单个选项只能选一次| 
|sort|自动排序|0:保留输入顺序<br>1:选项自动排序，默认| 
|max|最大可选人数|| 
|min|最小可选人数|| 
|maximum|最大可供选择项目数|1-10| 
|maxOptions|可选出数目|最小值是1，最大值不超出maximum| 
|topLimit|数字上限|浮点数格式的字符串| 
|lowerLimit|数字下限|浮点数格式的字符串| 

规则类型2：

| **Json字段** | **字段含义** | **赋值及含义** |
| --- | --- | --- |
|ruleType| 规则类型 |2| 
|mode|模式|0:默认（选择）| 
|modifyMode|修改模式|0:不可修改<br> 1:可修改，默认| 
|secrecyMode|保密模式|0:不保密，默认<br>  1:保密| 
|lessMode|迫选模式|0:不迫选，默认<br> 1:迫选| 
|repeat|重复模式|0:不限制，默认<br>1:单个选项只能选一次| 
|sort|自动排序|0:保留输入顺序<br>1:选项自动排序，默认| 
|max|最大可选人数|| 
|min|最小可选人数|| 
|retain|保留数字|数组 范围000-999| 
|range|数字范围|数组| 

数字范围数据结构
| **Json字段** | **字段含义** | **赋值及含义** |
| --- | --- | --- |
|rangeStart|数字范围开始|浮点数格式的字符串| 
|rangeEnd|数字范围结束|浮点数格式的字符串| 



指令样例：
```json
{
	"fun": "startKeyPadCustomQuestions",	
	"baseSn":"2023031402",
	"params": {
		"titleTable": ["单选题", "数字表决"],
		"optionTable": [
			["A", "B", "C", "D"],
			["同意", "反对", "弃权"]
		],
		"ruleTable": [{
				"ruleType": "1",
				"mode": "0",
				"modifyMode": "0",
				"secrecyMode": "0",
				"lessMode": "0",
				"repeat": "0",
				"sort": "1",
				"max": "4",
				"min": "1",
				"maximum": "4",
				"maxOptions": "1",
				"topLimit": "100.0",
				"lowerLimit": "0.1"
			},
			{
				"ruleType": "2",
				"mode": "0",
				"modifyMode": "0",
				"secrecyMode": "0",
				"lessMode": "0",
				"repeat": "0",
				"sort": "1",
				"max": "4",
				"min": "1",
				"retain": ["777", "999"],
				"range": [{
					"rangeStart": "1",
					"rangeEnd": "100"
				}, {
					"rangeStart": "101",
					"rangeEnd": "200"
				}, {
					"rangeStart": "201",
					"rangeEnd": "300"
				}]
			}
		],
		"permissionTable": [{
				"permission": "2",
				"keySnList": ["1479824643", "1479824644", "1479824645", "1479824646"]
			},
			{
				"permission": "1",
				"keySnList": ["1479824643", "1479824644", "1479824645", "1479824646"]
			}
		],
		"configTable": [{
				"number": "1",
				"titleID": "1",
				"optionID": "1",
				"ruleID": "1",
				"permissionID": "0"
			},
			{
				"number": "2",
				"titleID": "2",
				"optionID": "2",
				"ruleID": "2",
				"permissionID": "0"
			}
		]
	},
	"packetTag": "59"
}
```

接收：

fun: "startKeyPadCustomQuestions" //开始自定义题型

infos:{"state":"OK"}//返回状态,成功为OK

指令样例：

```json
{
	"fun": "startKeyPadCustomQuestions",	
	"baseSn":"2023031402",
	"infos": {
		"state": "OK"
	},
	"packetTag": "59"
}
```

##### 接收作答 

接收：

fun: "answerKeyPadCustomQuestions" //自定义题型返回

infos: {} 

数字范围数据结构
| **Json字段** | **字段含义** | **赋值及含义** |
| --- | --- | --- |
|Time|答题时间|单位秒| 
|keySn|键盘Sn|| 
|Seq|题序号|| 
|keyValue|键值|键盘提交的值| 



指令样例：
```json
{
	"fun": "answerKeyPadCustomQuestions",	
	"baseSn":"2023031402",
	"infos": {
		"time": "5.42",
		"keySn": "1479824643",
		"seq": "1",
		"keyValue": "12"
	},
	"packetTag": "1"
}
```


##### 退出作答

发送：

fun: "stopKeyPadCustomQuestions" //停止多题题型
params:{} //默认空


指令样例：
```json
{
	"fun": "stopKeyPadCustomQuestions",	
	"baseSn":"2023031402",
	"packetTag": "1"
}
```


接收：
fun: "stopKeyPadCustomQuestions" //停止键盘测试
baseId: "1"//收到的基站ID
infos:{"state":"OK"}//返回状态,成功为OK


指令样例：
```json
{
	"fun": "stopKeyPadCustomQuestions",	
	"baseSn":"2023031402",
	"infos": {
		"state": "OK"
	},
	"packetTag": "1"
}
```


##### 支持设备说明
| **基站+键盘** | **支持** | **备注** |
| --- | --- | --- |
| B200-2.4G+M6 | 支持 |需要指定键盘支持| 


#### 数字选举题型

##### 开始测试

发送：

fun: "startKeyPadDigitalElections" //开始
params：{}

| **Json字段** | **字段含义** | **赋值及含义** |
| --- | --- | --- |
|titleTable| 题目表 |数组[字符串]| 
|optionTable| 选项表 |数组<br>"预留 默认空"| 
|ruleTable| 规则表 |数组[内容请参考“规则字段解释”]| 
|permissionTable| 许可权限表 |数组| 
|configTable| 配置表 |数组| 



规则字段解释：

规则类型2：

| **Json字段** | **字段含义** | **赋值及含义** |
| --- | --- | --- |
|ruleType| 规则类型 |2 默认值2| 
|mode|模式|0:默认（选择）| 
|modifyMode|修改模式|0:不可修改<br> 1:可修改，默认| 
|secrecyMode|保密模式|0:不保密，默认<br>  1:保密| 
|lessMode|迫选模式|0:不迫选，默认<br> 1:迫选| 
|repeat|重复模式|0:不限制，默认<br>1:单个选项只能选一次| 
|sort|自动排序|0:保留输入顺序<br>1:选项自动排序，默认| 
|max|最大可选人数|| 
|min|最小可选人数|| 
|retain|保留数字|数组 范围000-999| 
|range|数字范围|数组| 

数字范围数据结构
| **Json字段** | **字段含义** | **赋值及含义** |
| --- | --- | --- |
|rangeStart|数字范围开始|浮点数格式的字符串| 
|rangeEnd|数字范围结束|浮点数格式的字符串| 


许可权限表结构表说明
| **Json字段** | **字段含义** | **赋值及含义** |
| --- | --- | --- |
|permission| 许可权限 |0:无[默认]<br>1: 允许<br>2: 禁止| 
|KeySnList| 键盘列表 |数组<br>"1479824643"<br>"1479824644"<br>"1479824645"<br>"1479824646"| 


配置表结构表说明
| **Json字段** | **字段含义** | **赋值及含义** |
| --- | --- | --- |
|ruleType| 题编号 |1-200| 
|titleID|题目表ID|1-200| 
|optionID|选项表ID|1-200| 
|ruleID|规则表ID|1-200| 
|permissionID|许可权限表ID|1-200| 


指令样例：
```json
{
	"fun": "startKeyPadDigitalElections",	
	"baseSn":"2023031402",
	"params": {
		"titleTable": ["数字选举1", "数字选举2", "数字选举3"],
		"optionTable": [
			["1", "2", "3", "4"]
		],
		"ruleTable": [{
			"ruleType": "2",
			"mode": "0",
			"modifyMode": "1",
			"secrecyMode": "0",
			"lessMode": "0",
			"repeat": "0",
			"sort": "1",
			"max": "4",
			"min": "1",
			"retain": ["777", "999"],
			"range": [{
				"rangeStart": "1",
				"rangeEnd": "999"
			}]
		}],
		"permissionTable": [{
			"permission": "0",
			"keySnList": []
		}],
		"configTable": [{
				"number": "1",
				"titleID": "1",
				"optionID": "1",
				"ruleID": "1",
				"permissionID": "0"
			},

			{
				"number": "2",
				"titleID": "2",
				"optionID": "1",
				"ruleID": "1",
				"permissionID": "0"
			},
			{
				"number": "3",
				"titleID": "3",
				"optionID": "1",
				"ruleID": "1",
				"permissionID": "0"
			}
		]
	},
	"packetTag": "1"
}
```

接收：

fun: "startKeyPadCustomQuestions" //开始自定义题型

infos:{"state":"OK"}//返回状态,成功为OK

指令样例：

```json
{
	"fun": "startKeyPadCustomQuestions",	
	"baseSn":"2023031402",
	"infos": {
		"state": "OK"
	},
	"packetTag": "59"
}
```

##### 接收作答 

接收：

fun: "answerKeyPadCustomQuestions" //自定义题型返回

infos: {} 

数字范围数据结构
| **Json字段** | **字段含义** | **赋值及含义** |
| --- | --- | --- |
|Time|答题时间|单位秒| 
|keySn|键盘Sn|| 
|Seq|题序号|| 
|keyValue|键值|键盘提交的值| 



指令样例：
```json
{
	"fun": "answerKeyPadCustomQuestions",	
	"baseSn":"2023031402",
	"infos": {
		"time": "5.42",
		"keySn": "1479824643",
		"seq": "1",
		"keyValue": "12"
	},
	"packetTag": "1"
}
```


##### 退出作答

发送：

fun: "stopKeyPadCustomQuestions" //停止多题题型
params:{} //默认空


指令样例：
```json
{
	"fun": "stopKeyPadCustomQuestions",	
	"baseSn":"2023031402",
	"packetTag": "1"
}
```


接收：
fun: "stopKeyPadCustomQuestions" //停止键盘测试
baseId: "1"//收到的基站ID
infos:{"state":"OK"}//返回状态,成功为OK


指令样例：
```json
{
	"fun": "stopKeyPadCustomQuestions",	
	"baseSn":"2023031402",
	"infos": {
		"state": "OK"
	},
	"packetTag": "1"
}
```


#### 支持设备说明
| **基站+键盘** | **支持** | **备注** |
| --- | --- | --- |
| B200-2.4G+M6 | 支持 |需要指定键盘支持| 




## 刷卡

注意：在用MQTT操作基站参数时需要关注的发布主题和订阅主题如下：
|**主题**|**格式**|**说明**|
| --- | --- | --- |
| 发布主题 | /\${clientId}/${baseSn}/baseRW | 基站参数设置,查询指令 |
| 订阅主题 | /\${clientId}/${baseSn}/baseRe | 基站参数数据返回 |
| 订阅主题 | /\${clientId}/${baseSn}/stateCode | 状态码返回 |

刷卡流程：
![](img/image6.png)

刷卡后可以将键盘和基站自动完成配对。当需要刷卡绑定时应用软件先给基站发送一个键盘的姓名，键盘靠近基站感应区就会直接绑定当前数据并返回状态给应用。绑定成功后应用再发送下一个键盘的绑定信息，依次循环来绑定多个。

### 写刷卡数据

发送：

fun: "writeNFCInfo" //写NFC绑定数据
baseId: 1//1~32 (键盘所连基站ID)
params:{}//

| **Json字段** | **字段含义** | **赋值及含义** |
| --- | --- | --- |
|userName|姓名|最多24个汉字（48个字符）,键盘左上角显示| 
|matchCode|配对码|四字节 十六进制显示| 



指令样例：

```json
{
	"fun": "writeNFCInfo",	
	"baseSn":"2023031402",
	"params": {
		"userName": "张三",
		"matchCode": "22120007"
	},
	"packetTag": "1"
}
```

接收：
fun: "writeNFCInfo" //
baseId: "1"//收到的基站ID
infos:{"value":"OK"}//返回状态,成功为OK


指令样例：
```json
{
	"fun": "writeNFCInfo",	
	"baseSn":"2023031402",
	"infos": {
		"value": "OK"
	},
	"packetTag": "1"
}
```

 支持设备说明
| **基站+键盘** | **支持** | **备注** |
| --- | --- | --- |
| B200-2.4GS+S6 | 支持 |带NFC键盘有效| 

### 刷卡反馈

接收：
fun: "NFCInfo" //刷卡反馈
baseId: "1"//键盘所连基站ID
infos:{} 

| **Json字段** | **字段含义** | **赋值及含义** |
| --- | --- | --- |
|keySn|键盘Sn|| 
|state|状态|1:预留<br>2:基站报告NFC刷卡的键盘SN<br>3:预留<br>4:刷卡写指定配对码消息<br>5:基站报告M1刷卡的键盘SN| 
|number|数量|预留|


指令样例：

```json
{
	"fun": "NFCInfo",	
	"baseSn":"2023031402", 	
	"infos": {
		"keySn": "1479824643",
		"state": "4",
		"number": "0"
	},
	"packetTag": "1"
}
```

支持设备说明

|基站+键盘|支持/不支持|备注|
|---|---|---|
|B200-2.4GS+S6|支持||
|B200-2.4GS+M1|支持||
|B200-5.8G+T2|支持||


### NFC数据清除指令

发送：
fun: "writeNFCEmpty" //清除NFC数据
baseId: 1//1~32 (键盘所连基站ID)
params:{}//


指令样例：

```json
{
	"fun": "writeNFCEmpty",	
	"baseSn":"2023031402",	
	"params": {},
	"packetTag": "1"
}
```
接收：
fun: "writeNFCEmpty" //
baseId: "1"//收到的基站ID
infos:{"value":"OK"}//返回状态,成功为OK


指令样例：
```json
{
	"fun": "writeNFCEmpty",	
	"baseSn":"2023031402",
	"infos": {
		"value": "OK"
	},
	"packetTag": "1"
}
```

 支持设备说明
| **基站+键盘** | **支持** | **备注** |
| --- | --- | --- |
| B200-2.4GS+S6 | 支持 |带NFC键盘有效| 


## 硬件参数

硬件的读写操作返回数据都是相同的，具体值参见写指令的value

### 基站
注意：在用MQTT操作基站参数时需要关注的发布主题和订阅主题如下：

|**主题**|**格式**|**说明**|
| --- | --- | --- |
| 发布主题 | /\${clientId}/${baseSn}/baseRW | 基站参数设置,查询指令 |
| 订阅主题 | /\${clientId}/${baseSn}/baseRe | 基站参数数据返回 |
| 订阅主题 | /\${clientId}/${baseSn}/stateCode | 状态码返回 |

读

发送：
fun: "readBaseStationChannel" //读基站频点
baseSn:"2023031402"
params：{}//可不填


指令样例：

|**主题**|**格式**|**说明**|
| --- | --- | --- |
| 发布主题 | /\${clientId}/${baseSn}/baseRW | 基站参数设置,查询指令 |

```json
{
	"fun": "readBaseStationChannel",
	"baseSn":"2023031402",
	"packetTag": "1"
}
```

写

发送：
fun: "writeBaseStationChannel" //写基站频点
baseSn:"2023031402"
params：{"value":"1"}//1~12 （频点）

| **Json字段** | **字段含义** | **赋值及含义** |
| --- | --- | --- |
|values|基站频点|多频点基站有效| 


多频点基站指令样例：

|**主题**|**格式**|**说明**|
| --- | --- | --- |
| 发布主题 | /\${clientId}/${baseSn}/baseRW | 基站参数设置,查询指令 |

```json
{
	"fun": "writeBaseStationChannel",
	"baseSn":"2023031402",
	"params": {
		"values": ["3", "6", "9", "12"]
	},
	"packetTag": "1"
}
```

返回

接收：
fun: "baseStationChannel" 
baseSn:"2023031402"
infos:{"value":"3"}//返回基站频点值


指令样例：

|**主题**|**格式**|**说明**|
| --- | --- | --- |
| 订阅主题 | /\${clientId}/${baseSn}/baseRe | 基站参数数据返回 |

```json
{
	"fun": "baseStationChannel",
	"baseSn":"2023031402",
	"infos": {
		"values": ["3", "6", "9", "12"]
	},
	"packetTag": "1"
}
```


#### 基站频点

读

发送：
fun: "readBaseStationChannel" //读基站频点
baseSn:"2023031402"
params：{}//可不填


指令样例：

```json
{
	"fun": "readBaseStationChannel",
	"baseSn":"2023031402",
	"packetTag": "1"
}
```

写

发送：
fun: "writeBaseStationChannel" //写基站频点
baseSn:"2023031402"
params：{"value":"1"}//1~12 （频点）

| **Json字段** | **字段含义** | **赋值及含义** |
| --- | --- | --- |
|value|基站频点|单频点基站有效| 
|values|基站频点|多频点基站有效| 


单频点基站指令样例：

```json
{
	"fun": "writeBaseStationChannel",
	"baseSn":"2023031402",
	"params": {
		"value": "3"
	},
	"packetTag": "1"
}
```

多频点基站指令样例：

```json
{
	"fun": "writeBaseStationChannel",
	"baseSn":"2023031402",
	"params": {
		"values": ["3", "6", "9", "12"]
	},
	"packetTag": "1"
}
```

返回

接收：
fun: "baseStationChannel" 
baseSn:"2023031402"
infos:{"value":"3"}//返回基站频点值


指令样例：

```json
{
	"fun": "baseStationChannel",
	"baseSn":"2023031402",
	"infos": {
		"value": "3",
		"values": ["3", "6", "9", "12"]
	},
	"packetTag": "1"
}
```

支持设备说明
| **基站+键盘** | **支持** | **备注** |
| --- | --- | --- |
|B100-2.4GS+S6|支持单频点|频率范围1~80| 
|B200-2.4GS+S6|支持单频点|频率范围1~80| 
|B200-2.4GM+S6|支持多频点|频率范围1~80| 
|B200-5.8G+T2|支持单频点|频率范围1~12| 

#### 键盘登录菜单显示

读

发送：
fun: "readKeyboardLoginMenu" //读键盘登录菜单显示
baseId:  1//1~32 (必须指定基站)
params：{}//可不填


指令样例：

```json
{
	"fun": "readKeyboardLoginMenu",	
	"baseSn":"2023031402",
	"packetTag": "1"
}
```

写

发送：
fun: "writeKeyboardLoginMenu" //写键盘登录菜单显示
baseId: 1 //1~32  (必须指定基站)
params：{"value":"1"}//0~1 （0不允许登录；1允许登录）


指令样例：

```json
{
	"fun": "writeKeyboardLoginMenu",	
	"baseSn":"2023031402",
	"params": {
		"value": "1"
	},
	"packetTag": "1"
}
```

返回

接收：

fun: "baseStationKeyboardLoginMenu" 
baseId: 1//基站ID
infos:{"value":"1"}//返回键盘登录菜单显示值


指令样例：

```json
{
	"fun": "baseStationKeyboardLoginMenu",	
	"baseSn":"2023031402",
	"infos": {
		"value": "1"
	},
	"packetTag": "1"
}
```

支持设备说明

| **基站+键盘** | **支持** | **备注** |
| --- | --- | --- |
| B100-2.4G+S6  | 支持 || 
| B200-2.4G+S6  | 支持 || 



#### 基站型号(只读)

读

发送：

fun: "readBaseStationModel" //读基站型号
baseId:  1//1~32 (必须指定基站)
params：{}//可不填


指令样例：

```json
{
	"fun": "readBaseStationModel",	
	"baseSn":"2023031402",
	"packetTag": "1"
}
```

返回

接收：

fun: "baseStationModel" 
baseId: 1//基站ID
infos:{"value":"218"}//返回基站型号


指令样例：

```json
{
	"fun": "baseStationModel",	
	"baseSn":"2023031402",
	"infos": {
		"value": "218"
	},
	"packetTag": "1"
}
```

基站型号代码查询表

| **基站型号代码** | **基站型号** | **备注** |
| --- | --- | --- |
| 217  | B100-2.4G || 
| 218  | B200-2.4G || 
| 219  | B200-5.8G || 


支持设备说明

 | **基站+键盘** | **支持** | **备注** |
| --- | --- | --- |
| B100-2.4G+S6  | 支持 || 
| B200-2.4G+S6  | 支持 || 
| B200-5.8G+T2  | 支持 || 

#### 基站软件版本(只读)

读

发送：

fun: "readBaseStationSVersion" //读基站软件版本
baseId:  1//1~32 (必须指定基站)
params：{}//可不填


指令样例：

```json
{
	"fun": "readBaseStationSVersion",	
	"baseSn":"2023031402",
	"packetTag": "1"
}
```

返回

接收：

fun: "baseStationSVersion" 
baseId: 1//基站ID
infos:{"value":"V2.0.2"}//返回基站软件版本


指令样例：

```json
{
	"fun": "baseStationSVersion",	
	"baseSn":"2023031402",
	"infos": {
		"value": "V2.0.2"
	},
	"packetTag": "1"
}
```

支持设备说明

| **基站+键盘** | **支持** | **备注** |
| --- | --- | --- |
| B100-2.4G+S6  | 支持 || 
| B200-2.4G+S6  | 支持 || 
| B200-5.8G+T2  | 支持 || 

#### 基站序列号(只读)

读

发送：

fun: "readBaseStationSN" //读基站序列号
baseId:  1//1~32 (必须指定基站)
params：{}//可不填


指令样例：

```json
{
	"fun": "readBaseStationSN",	
	"baseSn":"2023031402",
	"packetTag": "1"
}
```

返回

接收：

fun: "baseStationSN" 
baseId: 1//基站ID
infos:{"value":"FFFFFFFFFF"}//返回基站序列号


指令样例：

```json
{
	"fun": "baseStationSN",	
	"baseSn":"2023031402",
	"infos": {
		"value": "FFFFFFFFFF"
	},
	"packetTag": "1"
}
```

支持设备说明

| **基站+键盘** | **支持** | **备注** |
| --- | --- | --- |
| B100-2.4G+S6  | 支持 || 
| B200-2.4G+S6  | 支持 || 
| B200-5.8G+T2  | 支持 || 

#### 基站名称

读

发送：

fun: "readBaseStationTitle" //读基站名称
baseId:  1//1~32 (必须指定基站)
params：{}//可不填


指令样例：

```json
{
	"fun": "readBaseStationTitle",	
	"baseSn":"2023031402",
	"packetTag": "1"
}
```

写

发送：

fun: "writeBaseStationTitle" //写基站名称
baseId: 1//1~32(必须指定基站)
params：{"value":" A2021"}//基站名称，最长12字节


指令样例：

```json
{
	"fun": "writeBaseStationTitle",	
	"baseSn":"2023031402",
	"params": {
		"value": "A2021"
	},
	"packetTag": "1"
}
```

返回

接收：

fun: "baseStationTitle" 
baseId: 1//基站ID
infos:{"value":"A2021"}//返回基站名称


指令样例：

```json
{
	"fun": "baseStationTitle",	
	"baseSn":"2023031402",
	"infos": {
		"value": "A2021"
	},
	"packetTag": "1"
}
```

支持设备说明

| **基站+键盘** | **支持** | **备注** |
| --- | --- | --- |
| B100-2.4G+S6  | 支持 || 
| B200-2.4G+S6  | 支持 || 
| B200-5.8G+T2  | 支持 || 

#### 基站配对模式[内部使用]
读
发送：
fun: "readPairMode" //读基站配对模式
baseId:  1//1~32 (必须指定基站)
params：{}//可不填

指令样例：
```json
{
	"fun": "readPairMode",	
	"baseSn":"2023031402",
	"packetTag": "1"
}
```

写
发送：
fun: "writePairMode" //写基站配对模式
baseId: 1//1~32  (必须指定基站)
params：{"value":"4"}//1~9 	

| **Json字段** | **字段含义** | **赋值及含义** |
| --- | --- | --- |
|value|模式|1:固定模式<br>2:自由模式<br>3:免配对模式<br>4:配对SN号模式<br>5:自由SN号模式<br>6:免配对SN号模式<br>7:免配对同频点SN模式<br>8:白名单模式<br>9:免配对白名单模式| 

在S6型号中 配对模式只有 固定模式和白名单模式，在固定模式中可是使用快速配对方式登录，也可以使用菜单登录方式登录。


| **配对模式** | **键盘识别** | **免配对开关** | **原键盘使用模式** |
| --- | --- | --- | --- |
|固定模式|ID|关闭|1：固定模式|
|固定模式|SN|关闭|4：配对SN号模式| 
|固定模式|ID|开启|3：免配对模式|
|固定模式|SN|开启|6：免配对SN模式|
|白名单|ID|关闭|无效|
|白名单|SN|关闭|8：白名单模式|
|白名单|ID|开启|无效|
|白名单|SN|开启|9：免配对白名单模式|

指令样例：
```json
{
	"fun": "writePairMode",	
	"baseSn":"2023031402",
	"params": {
		"value": "4"
	},
	"packetTag": "1"
}
```

返回
接收：
fun: "pairMode" 
baseId: 1//基站ID
infos:{"value":"4"}//返回基站配对模式值

指令样例：
```json
{
	"fun": "pairMode",	
	"baseSn":"2023031402",
	"infos": {
		"value": "4"
	},
	"packetTag": "1"
}
```

| **配对模式** | **键盘识别** | **免配对开关** | **原键盘使用模式** |
| --- | --- | --- | --- |
|固定模式|ID|关闭|1：固定模式|
|固定模式|SN|关闭|4：配对SN号模式| 
|固定模式|ID|开启|3：免配对模式|
|固定模式|SN|开启|6：免配对SN模式|
|白名单|ID|关闭|无效|
|白名单|SN|关闭|8：白名单模式|
|白名单|ID|开启|无效|
|白名单|SN|开启|9：免配对白名单模式|



支持设备说明

| **基站+键盘** | **支持** | **备注** |
| --- | --- | --- |
| B100-2.4G+S6  | 支持 || 
| B200-2.4G+S6  | 支持 || 
| B200-5.8G+T2  | 支持 || 


#### 基站配对模式
读
发送：
fun: "readBaseStationPairMode" //读基站配对模式
baseId:  1//1~32 (必须指定基站)
params：{}//可不填

指令样例：
```json
{
	"fun": "readBaseStationPairMode",	
	"baseSn":"2023031402",
	"packetTag": "1"
}
```


<font color="#dd0000" size="5">注意：写操作请谨慎使用。</font><br /> 

写
发送：
fun: "writeBaseStationPairMode" //写基站配对模式
baseId: 1//1~32  (必须指定基站)
params：{"value":"1"}//

| **Json字段** | **字段含义** | **赋值及含义** |
| --- | --- | --- |
|value|模式|1:配对SN号模式<br>2:白名单模式| 


指令样例：
```json
{
	"fun": "writeBaseStationPairMode",	
	"baseSn":"2023031402",
	"params": {
		"value": "1"
	},
	"packetTag": "1"
}
```

返回
接收：
fun: "baseStationPairMode" 
baseId: 1//基站ID
infos:{"value":"1"}//返回基站配对模式值

指令样例：
```json
{
	"fun": "baseStationPairMode",	
	"baseSn":"2023031402",
	"infos": {
		"value": "1"
	},
	"packetTag": "1"
}
```

支持设备说明

| **基站+键盘** | **支持** | **备注** |
| --- | --- | --- |
| B200-2.4G+S6  | 支持 || 
| B200-5.8G+T2  | 支持 || 

#### 基站配对码

读

发送：

fun: "readBaseStationMatchCode" //读基站配对码
baseId:  1//1~32 (必须指定基站)
params：{}//可不填


指令样例：

```json
{
	"fun": "readBaseStationMatchCode",	
	"baseSn":"2023031402",
	"packetTag": "1"
}
```

返回

接收：

fun: "baseStationMatchCode" 
baseId: 1//基站ID
infos:{"value":"21072333"}//返回基站配对码


指令样例：

```json
{
	"fun": "baseStationMatchCode",	
	"baseSn":"2023031402",
	"infos": {
		"value": "21072333"
	},
	"packetTag": "1"
}
```

支持设备说明

| **基站+键盘** | **支持** | **备注** |
| --- | --- | --- |
| B100-2.4G+S6  | 支持 || 
| B200-2.4G+S6  | 支持 || 
| B200-5.8G+T2  | 支持 || 


#### 基站频点冲突

检测到基站频点冲突将会返回给应用程序提示，应用程序可根据情况更改频点。
接收：
fun: "baseStationChannelInterference" // 基站频点冲突
baseId: //发生冲突基站ID 
infos:{ "value":"5"}//频点5冲突 
packetTag:"0"//数据包标签


指令样例：

```json
{
	"fun": "baseStationChannelInterference",	
	"baseSn":"2023031402",
	"infos": {
		"value": "5"
	},
	"packetTag": "0"
}
```

支持设备说明

| **基站+键盘** | **支持** | **备注** |
| --- | --- | --- |
| B100-2.4G+S6  | 支持 || 
| B200-2.4G+S6  | 支持 || 
| B200-5.8G+T2  | 支持 || 

#### 基站容量

读

发送：

fun: "readBaseStationCapacity" //读基站容量
baseId:  1//1~32 (必须指定基站)
params：{}//可不填


指令样例：

```json
{
	"fun": "readBaseStationCapacity",	
	"baseSn":"2023031402",
	"packetTag": "1"
}
```

返回

接收：

fun: "baseStationCapacity" 
baseId: "1"//基站ID
infos:{"keypadNumber":"60","lock":"1"}//返回基站键盘容量值


指令样例：

```json
{	
	"fun": "baseStationCapacity",	
	"baseSn":"2023031402",
	"infos": {
		"keypadNumber": "60",
		"lock": "1"
	},
	"packetTag": "1"
}
```

支持设备说明
| **基站+键盘** | **支持** | **备注** |
| --- | --- | --- |
| B200-5.8G+T2  | 支持 || 


#### 快速配对

##### 开始快速配对

发送：

fun: "startQuickMatch" //开始快速配对
baseId:1		// 1~32 (必选参数,范围（1~32）)
params：{} 


指令样例：

```json
{
	"fun": "startQuickMatch",	
	"baseSn":"2023031402",
	"packetTag": "1"
}
```

接收：

fun: "startQuickMatch" //开始快速配对

infos:{"state":"OK"}//返回状态,成功为OK


指令样例：

```json
{
	"fun": "startQuickMatch",	
	"baseSn":"2023031402",
	"infos": {
		"state": "OK"
	},
	"packetTag": "1"
}
```

##### 停止快速配对

发送：

fun: "stopQuickMatch" //停止快速配对
params:{} //默认空


指令样例：

```json
{
	"fun": "stopQuickMatch",	
	"baseSn":"2023031402",
	"packetTag": "1"
}
```

接收：

fun: "stopQuickMatch" //停止快速配对
baseId: "1"//收到的基站ID
infos:{"state":"OK"}//返回状态,成功为OK


指令样例：

```json
{
	"fun": "stopQuickMatch",	
	"baseSn":"2023031402",
	"infos": {
		"state": "OK"
	},
	"packetTag": "1"
}
```

##### 支持设备说明

| **基站+键盘** | **支持** | **备注** |
| --- | --- | --- |
| B100-2.4G+S6  | 支持 || 
| B200-2.4G+S6  | 支持 || 


#### 键盘登录密码

读

发送：

fun: "readKeyboardLoginPW" //读键盘登录密码
baseId:  1//1~32 (必须指定基站)
params：{}//可不填


指令样例：

```json
{
	"fun": "readKeyboardLoginPW",	
	"baseSn":"2023031402",
	"packetTag": "1"
}
```

写

发送：

fun: "writeKeyboardLoginPW" //写键盘登录密码
baseId: 1 //1~32  (必须指定基站)
params：{"value":"0"}//0~9999 （0不用核对）

指令样例：

```json
{
	"fun": "writeKeyboardLoginPW",	
	"baseSn":"2023031402",
	"params": {
		"value": "0"
	},
	"packetTag": "1"
}
```

返回

接收：

fun: "baseStationKeyboardLoginPW" 
baseId: 1//基站ID
infos:{"value":"1"}//返回键盘登录密码值


指令样例：

```json
{
	"fun": "baseStationKeyboardLoginPW",	
	"baseSn":"2023031402",
	"infos": {
		"value": "0"
	},
	"packetTag": "1"
}
```

支持设备说明
| **基站+键盘** | **支持** | **备注** |
| --- | --- | --- |
| B100-2.4G+S6  | 支持 || 
| B200-2.4G+S6  | 支持 || 


#### 基站名称隐藏

读

发送：

fun: "readBaseStationNameHidden" //读基站名称隐藏
baseId:  1//1~32 (必须指定基站)
params：{}//可不填


指令样例：

```json
{
	"fun": "readBaseStationNameHidden",	
	"baseSn":"2023031402",
	"packetTag": "1"
}
```

写

发送：

fun: "writeBaseStationNameHidden" //写基站名称隐藏
baseId: 1 //1~32  (必须指定基站)
params：{"value":"0"}//0~1 （0隐藏，1不隐藏）

| **Json字段** | **字段含义** | **赋值及含义** |
| --- | --- | --- |
|value|模式|0:隐藏<br>1:不隐藏| 

指令样例：

```json
{
	"fun": "writeBaseStationNameHidden",	
	"baseSn":"2023031402",
	"params": {
		"value": "0"
	},
	"packetTag": "1"
}
```

返回

接收：

fun: "baseStationNameHidden" 
baseId: 1//基站ID
infos:{"value":"1"}//返回基站名称隐藏值  （0隐藏，1不隐藏）


指令样例：

```json
{
	"fun": "baseStationNameHidden",	
	"baseSn":"2023031402",
	"infos": {
		"value": "0"
	},
	"packetTag": "1"
}
```

支持设备说明
| **基站+键盘** | **支持** | **备注** |
| --- | --- | --- |
| B100-2.4G+S6  | 支持 || 
| B200-2.4G+S6  | 支持 || 

#### 基站TCP/IP参数

读

发送：

fun: "readBaseStationTcpIp" //读基站TCP/IP参数
baseId:  1//1~32 (必须指定基站)
params：{}//可不填


指令样例：

```json
{
	"fun": "readBaseStationTcpIp",	
	"baseSn":"2023031402",
	"packetTag": "1"
}
```

写

发送：

fun: "writeBaseStationTcpIp" //写基站TcpIp
baseId: 1 //1~32  (必须指定基站)
params： 


指令样例：

```json
{
	"fun": "writeBaseStationTcpIp",	
	"baseSn":"2023031402",
	"params": {
		"mac": "FF:FF:FF:FF:FF:FF",
		"ip": "192.168.10.10",
		"mask": "255.255.255.0",
		"gateway": "192.168.10.1"
	},

	"packetTag": "1"
}
```

返回

接收：

fun: "baseStationTcpIp" 
baseId: 1//基站ID
infos:{"value":"1"}//返回基站TcpIp


指令样例：

```json
{
	"fun": "baseStationTcpIp",	
	"baseSn":"2023031402",
	"infos": {
		"ip": "192.168.10.10",
		"mac": "FF:FF:FF:FF:FF:FF",
		"mask": "255.255.255.0",
		"gateway": "192.168.10.1"
	},
	"packetTag": "1"
}
```

支持设备说明
| **基站+键盘** | **支持** | **备注** |
| --- | --- | --- |
| EA4000T-2.4G+S5  | 支持 |带LAN接口版本| 


#### 基站键盘白名单管理

读

发送：

fun: "readWhiteList" //读白名单列表
baseId:  1//1~32 (必须指定基站)


指令样例：

```json
{
	"fun": "readWhiteList",	
	"baseSn":"2023031402",
	"params": {},
	"packetTag": "1"
}
```

读返回
接收：
fun: "whiteList" 
baseId: 1 //1~32 (必须指定基站)
infos:{}//

| **Json字段** | **字段含义** | **赋值及含义** |
| --- | --- | --- |
|keySn|键盘Sn|| 
|state|键盘状态<br>[B200_5.8G+T2组合有效]|0:离线<br>1:在线| 

指令样例：

```json
{
	"fun": "whiteList",	
	"baseSn":"2023031402",
	"infos": [{
			"keySn": "2111120140",
			"state": "0"
		},
		{
			"keySn": "0005243136",
			"state": "0"
		},
		{
			"keySn": "2111120102",
			"state": "0"
		}
	],
	"packetTag": "1"
}
```

写

<font color="#dd0000" size="5">注意：写操作前请把基站配对模式切换到白名单模式。</font><br /> 

发送：

fun: "writeWhiteList" //写白名单列表
baseId: 1 //1~32  (必须指定基站)
keySnList：[]//键盘SN数组最多200键盘SN

| **Json字段** | **字段含义** | **赋值及含义** |
| --- | --- | --- |
|keySnList|键盘列表|B200-2.4GS+S6:键盘最多 200只<br>EA3100-2.4G+S62:键盘最多 200只<br>B200-5.8G+T2:键盘最多 需要参考 7.5.1.10基站容量| 


指令样例：

```json
{
	"fun": "writeWhiteList",	
	"baseSn":"2023031402",
	"keySnList": [{
			"keySn": "2111120140"
		},
		{
			"keySn": "0005243136"
		},
		{
			"keySn": "2111120102"
		}
	],
	"packetTag": "10"
}
```

返回

接收：

fun: "whiteList" 
baseId:  1//1~32 (必须指定基站)
infos:{}// 

| **Json字段** | **字段含义** | **赋值及含义** |
| --- | --- | --- |
|keySn|键盘Sn|| 
|state|键盘状态|OK：成功| 

指令样例：

```json
{
	"fun": "whiteList",	
	"baseSn":"2023031402",
	"infos": [{
			"keySn": "2111120140",
			"state": "OK"
		},
		{
			"keySn": "0005243136",
			"state": "OK"
		},
		{
			"keySn": "2111120102",
			"state": "OK"
		}
	],
	"packetTag": "1"
}
```

支持设备说明

| **基站+键盘** | **支持** | **备注** |
| --- | --- | --- |
| B200-2.4G+S6 | 支持 || 
| B200-5.8G+T2 | 支持 || 
| EA3100-2.4G+S62 | 支持 |EA3100写白名单后，返回是没有STATE状态|

#### 基站锁定键盘

发送：
fun: "lockKeypad" //锁定键盘
baseId: 0// 0~32 (指令不发送baseID，默认为0表示所有基站)
params:{} //数组对象，指定键盘需填

| **Json字段** | **字段含义** | **赋值及含义** |
| --- | --- | --- |
|baseId|基站id|在指定键盘时请传对应的基站baseId<br>0：所有基站| 
|keySnList|键盘列表|没有列表时为锁定当前所有在线列表| 

指令样例：
锁定指定键盘
```json
{
	"fun": "lockKeypad",	
	"baseSn":"2023031402",
	"keySnList": [{
			"keySn": "2111120140"
		},
		{
			"keySn": "0005243136"
		},
		{
			"keySn": "2111120102"
		}
	],
	"params": {},
	"packetTag": "1"
}
```

接收：
```json
{
	"fun": "lockKeypad",	
	"baseSn":"2023031402",
	"infos": [{
			"keySn": "1837454011",
			"state": "OK"
		},
		{
			"keySn": "1837454012",
			"state": "OK"
		}
	],
	"packetTag": "1"
}
```

支持设备说明

| **基站+键盘** | **支持** | **备注** |
| --- | --- | --- |
| B200-5.8G+T2 | 支持 || 

#### 基站解锁键盘
发送：
fun: "unlockKeypad" //解锁键盘
baseId:  1//1~32 (必须指定基站)
params:{} //数组对象，指定键盘需填

| **Json字段** | **字段含义** | **赋值及含义** |
| --- | --- | --- |
|baseId|基站id|在指定键盘时请传对应的基站baseId<br>0：所有基站| 
|keySnList|键盘列表|没有列表时为解锁所有键盘| 

指令样例：

解锁键盘
```json
{
	"fun": "unlockKeypad",	
	"baseSn":"2023031402",
	"keySnList": [{
			"keySn": "2111120140"
		},
		{
			"keySn": "0005243136"
		},
		{
			"keySn": "2111120102"
		}
	],
	"params": {},
	"packetTag": "1"
}
```

接收：
```json
{
	"fun": "unlockKeypad",	
	"baseSn":"2023031402",
	"infos": [{
			"keySn": "2111120140",
			"state": "OK"
		},
		{
			"keySn": "0005243136",
			"state": "OK"
		},
		{
			"keySn": "2111120102",
			"state": "OK"
		}
	],
	"packetTag": "1"
}
```

| **基站+键盘** | **支持** | **备注** |
| --- | --- | --- |
| B200-5.8G+T2 | 支持 || 

#### 基站追加键盘 

发送：
fun: "addWhiteList" //追加键盘
params:{} //键盘sn 
keySnList:[ "keySn":"2111120140"]	//列表不能为空

指令样例：

```json
{
	"fun": "addWhiteList",	
	"baseSn":"2023031402",
	"keySnList": [{
		"keySn": "2111120140"
	}],
	"params": {},
	"packetTag": "1"
}
```
接收：
fun: "whiteList" 
baseId: 1//基站ID
infos:{}//

| **Json字段** | **字段含义** | **赋值及含义** |
| --- | --- | --- |
|keySn|键盘SN|| 
|state|键盘状态|OK：成功| 

```json
{
	"fun": "whiteList",	
	"baseSn":"2023031402",
	"infos": {
		"keySn": "1837454012",
		"state": "OK"
	},
	"packetTag": "1"
}
```

| **基站+键盘** | **支持** | **备注** |
| --- | --- | --- |
| B200-2.4G+S6 | 支持 || 
| B200-5.8G+T2 | 支持 || 

#### 基站删除键盘 

发送：
fun: "delWhiteList" //踢出键盘,删除键盘
params:{} //键盘sn 
keySnList:[ "keySn":"2111120140"]	//列表不能为空


指令样例：

```json
{
	"fun": "delWhiteList",	
	"baseSn":"2023031402",
	"keySnList": [{
		"keySn": "2111120140"
	}],
	"params": {},
	"packetTag": "1"
}
```
接收：
fun: "delWhiteList" 
baseId: 1//基站ID
infos:{}//

| **Json字段** | **字段含义** | **赋值及含义** |
| --- | --- | --- |
|keySn|键盘SN|| 
|state|键盘状态|OK：成功| 

```json
{
	"fun": "delWhiteList",	
	"baseSn":"2023031402",
	"packetTag": "1",
	"infos": {
		"keySn": "1837454012",
		"state": "OK"
	}
}
```

| **基站+键盘** | **支持** | **备注** |
| --- | --- | --- |
| B200-2.4G+S6 | 支持 || 
| B200-5.8G+T2 | 支持 || 

#### 基站清掉所有键盘 

发送：
fun: "clearWhiteList" //清掉所有键盘
params:{} //无 



指令样例：

```json
{
	"fun": "clearWhiteList",	
	"baseSn":"2023031402",
	"packetTag": "1"
}
```
接收：
fun: "clearWhiteList" 
baseId: 1//基站ID
infos:{}//

| **Json字段** | **字段含义** | **赋值及含义** |
| --- | --- | --- |
|state|键盘状态|OK：成功| 

```json
{
	"fun": "clearWhiteList",	
	"baseSn":"2023031402",
	"packetTag": "1",
	"infos": {
		"state": "OK"
	}
}
```

| **基站+键盘** | **支持** | **备注** |
| --- | --- | --- |
| B200-2.4G+S6 | 支持 || 
| B200-5.8G+T2 | 支持 || 
| EA3100-2.4G+S62 | 支持 || 

#### 键盘关机时间

读
发送：
fun: "readKeypadAutoPowerOffLevel" //读键盘关机时间等级
baseId:  1//1~32 (必须指定基站)
params：{"value":0}//

| **Json字段** | **字段含义** | **赋值及含义** |
| --- | --- | --- |
|value|键盘关机时间等级|0-30秒<br>1:2分钟<br>2:10分钟<br>3:45分钟<br>255:不自动关机| 

指令样例：
```json
{
	"fun": "readKeypadAutoPowerOffLevel",	
	"baseSn":"2023031402",
	"packetTag": "1"
}
```

写
发送：
fun: "writeKeypadAutoPowerOffLevel" //写键盘关机时间等级
baseId: 1//1~32 (必须指定基站)
params：{"value":"0"}//

指令样例：

```json
{
	"fun": "writeKeypadAutoPowerOffLevel",	
	"baseSn":"2023031402",
	"params": {
		"value": "0"
	},
	"packetTag": "1"
}
```

返回
接收：
fun: "keypadAutoPowerOffLevel" 
baseId: 1//基站ID
infos:{"value":"0"}//返回键盘关机时间等级
指令样例：

```json
{
	"fun": "keypadAutoPowerOffLevel",	
	"baseSn":"2023031402",
	"infos": {
		"value": "0"
	},
	"packetTag": "1"
}
```

| **基站+键盘** | **支持** | **备注** |
| --- | --- | --- |
| 全系列 | 支持 || 

#### 基础参数配置

读
发送：
fun: "readBaseStationBaseConfig" //读基站BaseConfig
baseId:  1//1~32 (必须指定基站)
params：{}//可不填

指令样例：
```json
{
	"fun": "readBaseStationBaseConfig",	
	"baseSn":"2023031402",
	"packetTag": "1"
}
```

写
发送：
fun: "writeBaseStationBaseConfig" //写基站BaseConfig
baseId: 1 //1~32  (必须指定基站)
params：{}//

| **Json字段** | **字段含义** | **赋值及含义** |
| --- | --- | --- |
|bootVibraton|开机震动|0: 关闭<br>1: 开启| 
|voteVibraton|答题开始震动|0: 关闭<br>1: 开启| 
|led|指示灯开关|0: 关闭<br>1: 开启| 


指令样例：

```json
{
	"fun": "writeBaseStationBaseConfig",	
	"baseSn":"2023031402",
	"params": {
		"bootVibraton": "1",
		"voteVibraton": "1",
		"led": "1"
	},
	"packetTag": "1"
}
```

返回
接收：
fun: "baseStationBaseConfig" 
baseId: 1//基站ID
infos:{ }//返回基站

指令样例：

```json
{
	"fun": "baseStationBaseConfig",	
	"baseSn":"2023031402",
	"infos": {
		"bootVibraton": "1",
		"voteVibraton": "1",
		"led": "1"
	},
	"packetTag": "1"
}
```

| **基站+键盘** | **支持** | **备注** |
| --- | --- | --- |
| B200-5.8G+T2 | 支持 || 

#### 基站AES  

读
发送：
fun: "readBaseStationAES" //读基站AES
baseId:  1//1~32 (必须指定基站)
params：{}//可不填

指令样例：
```json
{
    "fun":"readBaseStationAES",
    
	"baseSn":"2023031402",
    "packetTag":"1"
}
```

写
发送：
fun: "writeBaseStationAES" //写基站AES
baseId: 1 //1~32  (必须指定基站)
params：{"value":"0"}//

| **Json字段** | **字段含义** | **赋值及含义** |
| --- | --- | --- |
| baseId | 基站ID | 1~32 |
| value | 加密模式 | 0:无线不加密<br>1:无线AES128加密<br>2:无线 AES256加密 |

指令样例：
```json
{
    "fun":"writeBaseStationAES",
    
	"baseSn":"2023031402",
    "packetTag":"1"
}
```

返回
接收：
fun: "baseStationAES" 
baseId: 1//基站ID
infos:{"value":"1"}//返回基站AES

指令样例：
```json
{
    "fun": "baseStationAES",
    
	"baseSn":"2023031402",
    "infos": {
        "value": "0"
    },
    "packetTag": "1"
}
```

克隆参数
发送：
fun: "copyBaseStationAES" //克隆基站AES参数
baseId:  1//1~32 (必须指定基站)  
params：{}//

| **Json字段** | **字段含义** | **赋值及含义** |
| --- | --- | --- |
| destBaseID | 目标基站ID | 1~32 |
| sourceBaseID | 来源基站ID | 1~32 |


指令样例：
```json
{
    "fun": "copyBaseStationAES",
    
	"baseSn":"2023031402",
    "params": {
        "destBaseID": "2",
        "sourceBaseID": "1"
    },
    "packetTag": "1"
}
```

返回
接收：
fun: " copyBaseStationAES " 
baseId: 1//基站ID
infos:{"value":"OK"}//返回状态

指令样例：
```json
{
    "fun": "baseStationAES",
    
	"baseSn":"2023031402",
    "infos": {
        "value": "OK"
    },
    "packetTag": "1"
}
```
支持设备说明

| **基站+键盘** | **支持** | **备注** |
| --- | --- | --- |
| B200-2.4GM+S6 | 支持 |  |


#### 基础配置模式[内部使用]

读
发送：
fun: "readBasicConfigMode" //
baseId:  1//1~32 (必须指定基站)
params：{}//可不填

指令样例：
```json
{
	"fun": "readBasicConfigMode",	
	"baseSn": "2023031402",
	"packetTag": "1"
}
```

写
发送：
fun: "writeBasicConfigMode" //
baseId: 1 //1~32  (必须指定基站)
params：{"value":"0"}//

| **Json字段** | **字段含义** | **赋值及含义** |
| --- | --- | --- |
| baseId | 基站ID | 1~32 |
| beacon | 信标模式 | 0:正常发信标<br>1:不发信标 |
| listenIn | 监听模式 | 0:无意义<br>1:基站开启回复键盘·监听模式（基站进入键盘升级自动关闭该设置) |

指令样例：
```json
{
    "fun":"writeBasicConfigMode",    
	"baseSn":"2023031402",
	"params": {
        "beacon": "0",
        "listenIn": "0"
    },
    "packetTag":"1"
}
```

返回
接收：
fun: "basicConfigMode" 
baseId: 1//基站ID
infos:{"beacon":"0", "listenIn":"0"}//

指令样例：
```json
{
	"fun": "basicConfigMode",	
	"baseSn": "2023031402",
	"infos": {
		"beacon": "0",
		"listenIn": "0"
	},
	"packetTag": "1"
}
```


### 键盘

注意：在用MQTT操作键盘参数时需要关注的发布主题和订阅主题如下：

|**主题**|**格式**|**说明**|
| --- | --- | --- |
| 发布主题 | /\${clientId}/${baseSn}/keyRW | 键盘参数设置,查询指令 |
| 订阅主题 | /\${clientId}/${baseSn}/keyRe| 键盘参数数据返回 |
| 订阅主题 | /\${clientId}/${baseSn}/stateCode | 状态码返回 |


键盘写参数可以不指定键盘SN，则对所有在线键盘进行写操作，但没有键盘状态返回。如需指定键盘信息下发，则需要指定键盘SN，所有键盘状态返回。

注：如果一条指定键盘指令中有一个keySN为空，则该指令会按不指定键盘执行。

#### 键盘外设(只写)

写

fun: "writeKeypadDevice" //写键盘外设,由led灯、蜂鸣器、马达组合
params：{} //

数组对象,对象中的默认值为空字符串，各类(led、beep、motor)外设字段都不设置,表示该类不设置

| **Json字段** | **字段含义** | **赋值及含义** |
| --- | --- | --- |
| keySn | 键盘SN |空字符串，为所有在线键盘|
| ledTimes | Led灯闪烁次数 | 0~255 (0是马上灭，255是长亮)|
| ledOnTime | Led灯每次开时间 |0~255 (单位0.1s)|
| ledOffTime | Led灯每次关时间 |0~255 (单位0.1s，为0就是连续亮)|
| ledColorR | Led灯灯颜色,红值 |0~255(现只支持0灭和1亮,，>1也认为是1)|
| ledColorG | Led灯灯颜色,绿值 |0~255(现只支持0灭和1亮,，>1也认为是1)|
| ledColorB | Led灯灯颜色,蓝值 |0~255(现只支持0灭和1亮,，>1也认为是1)|
| beepTimes | 蜂鸣器响次数 | 0~255 (0是马上响，255是长响) |
| beepOnTime | 蜂鸣器每次开时间 |0~255 (单位0.1s)|
| beepOffTime | 蜂鸣器每次关时间 |0~255 (单位0.1s，为0就是连续响)|
| motorTimes |马达震动次数|0~255|
| motorOnTime | 马达每次开时间 |0~255 (单位0.1s)|
| motorOffTime | 马达每次关时间 |0~255 (单位0.1s，为0就是连续振动)|

指令样例：

所有键盘

|**主题**|**格式**|**说明**|
| --- | --- | --- |
| 发布主题 | /\${clientId}/${baseSn}/keyRW | 键盘参数设置,查询指令 |

```json
{
	"fun": "writeKeypadDevice",
	"baseSn":"2023031402",
	"params": {
		"ledTimes": "3",
		"ledOnTime": "1",
		"ledOffTime": "1",
		"ledColorR": "1",
		"ledColorG": "1",
		"ledColorB": "1",
		"beepTimes": "3",
		"beepOnTime": "1",
		"beepOffTime": "1",
		"motorTimes": "3",
		"motorOnTime": "2",
		"motorOffTime": "1"
	},
	"packetTag": "1"
}
```

返回

fun: "writeKeypadDevice" 
infos:{"state":"OK"}//返回状态,成功为OK


指令样例：

|**主题**|**格式**|**说明**|
| --- | --- | --- |
| 订阅主题 | /\${clientId}/${baseSn}/keyRe| 键盘参数数据返回 |
| 订阅主题 | /\${clientId}/${baseSn}/stateCode | 状态码返回 |

```json
{
	"fun": "writeKeypadDevice",	
	"baseSn":"2023031402",
	"infos": {
		"keySn": "0000000000",
		"state": "OK"
	},
	"packetTag": "1"
}
```

指定键盘

|**主题**|**格式**|**说明**|
| --- | --- | --- |
| 发布主题 | /\${clientId}/${baseSn}/keyRW | 键盘参数设置,查询指令 |
| 订阅主题 | /\${clientId}/${baseSn}/stateCode | 状态码返回 |

```json
{
	"fun": "writeKeypadDevice",	
	"baseSn":"2023031402",
	"keySnList": [{
		"keySn": "0007899478"
	}],
	"params": {
		"ledTimes": "3",
		"ledOnTime": "1",
		"ledOffTime": "1",
		"ledColorR": "1",
		"ledColorG": "1",
		"ledColorB": "1",
		"beepTimes": "3",
		"beepOnTime": "1",
		"beepOffTime": "1",
		"motorTimes": "3",
		"motorOnTime": "2",
		"motorOffTime": "1"
	},
	"packetTag": "1"
}
```

返回

fun: "writeKeypadDevice" 
infos:{}//数组对象,同发送的


指令样例：

|**主题**|**格式**|**说明**|
| --- | --- | --- |
| 订阅主题 | /\${clientId}/${baseSn}/keyRe| 键盘参数数据返回 |
| 订阅主题 | /\${clientId}/${baseSn}/stateCode | 状态码返回 |

```json
{	
	"fun": "writeKeypadDevice",	
	"baseSn":"2023031402",
	"infos": {
		"keySn": "0007899478",
		"state": "OK"
	},
	"packetTag": "1"
}
```

支持设备说明

| **基站+键盘** | **支持** | **备注** |
| --- | --- | --- |
| B200-5.8G+T2 | 支持 | 蜂鸣器部分参数无效 |

#### 键盘反馈参数

读
发送：
fun: "readKeypadFeedbackMode" //读键盘反馈模式参数
baseId:  1//1~32 (必须指定基站)
params：{}//读取时不需要

指令样例：

|**主题**|**格式**|**说明**|
| --- | --- | --- |
| 发布主题 | /\${clientId}/${baseSn}/keyRW | 键盘参数设置,查询指令 |
| 订阅主题 | /\${clientId}/${baseSn}/stateCode | 状态码返回 |

```json
{
	"fun": "readKeypadFeedbackMode",	
	"baseSn":"2023031402",
	"packetTag": "1"
}
```

写

发送：
fun: "writeKeypadFeedbackMode" //写键盘反馈模式参数
baseId: 1//1~32 (必须指定基站)
params：{"mode":"1", "value":"4"}//

| **Json字段** | **字段含义** | **赋值及含义** |
| --- | --- | --- |
|mode|反馈模式| 0:不启用（默认0不启用）<br>1:通用键码|
|value|反馈最大有效按键|1~10|

指令样例：

|**主题**|**格式**|**说明**|
| --- | --- | --- |
| 发布主题 | /\${clientId}/${baseSn}/keyRW | 键盘参数设置,查询指令 |
| 订阅主题 | /\${clientId}/${baseSn}/stateCode | 状态码返回 |

```json
{
	"fun": "writeKeypadFeedbackMode",	
	"baseSn":"2023031402",
	"params": {
		"mode": "1",
		"value": "4"
	},
	"packetTag": "1"
}
```

返回

接收：
fun: "keypadFeedbackMode" 
baseId: 1//基站ID
infos:{ "mode":"1", "value":"4"}//返回键盘反馈模式参数值

| **Json字段** | **字段含义** | **赋值及含义** |
| --- | --- | --- |
|mode|反馈模式| 0:不启用（默认0不启用）<br>1:通用键码，不显示|
|value|反馈最大有效按键|1\~10|

指令样例：

|**主题**|**格式**|**说明**|
| --- | --- | --- |
| 订阅主题 | /\${clientId}/${baseSn}/keyRe| 键盘参数数据返回 |
| 订阅主题 | /\${clientId}/${baseSn}/stateCode | 状态码返回 |

```json
{
	"fun": "keypadFeedbackMode",	
	"baseSn":"2023031402",
	"infos": {
		"mode": "1",
		"value": "4"
	},
	"packetTag": "1"
}
```

支持设备说明

| **基站+键盘** | **支持** | **备注** |
| --- | --- | --- |
| B100-2.4G+S6 | 支持 |  |
| B200-2.4G+S6 | 支持 |  |


#### 键盘即时反馈[主动上报]

接收：

fun: "immediateFeedback"
baseId: 1//基站ID
infos:{ "keySn":"2307269906", "keyValue":"A"}//返回键盘反馈模式参数值

指令样例：
|**主题**|**格式**|**说明**|
| --- | --- | --- |
| 订阅主题 | /\${clientId}/${baseSn}/keyRe| 键盘参数数据返回 |
| 订阅主题 | /\${clientId}/${baseSn}/stateCode | 状态码返回 |

```json
{
	"fun": "immediateFeedback",	
	"baseSn":"2023031402",
	"infos": {
		"keySn": "2307269906",
		"keyValue": "A"
	},
	"packetTag": "0"
}
```

支持设备说明

| **基站+键盘** | **支持** | **备注** |
| --- | --- | --- |
| B100-2.4G+S6 | 支持 |  |
| B200-2.4G+S6 | 支持 |  |

#### 键盘上线通知[上报]

S6键盘上线后上报键盘SN信息。
接收：
fun: "keyboardOnlineOne" 
baseId: 1//基站ID
infos:{ "keySn":"1479824643"}//返回键盘反馈模式参数值

| **Json字段** | **字段含义** | **赋值及含义** |
| --- | --- | --- |
|keySn|键盘Sn||

指令样例：

|**主题**|**格式**|**说明**|
| --- | --- | --- |
| 订阅主题 | /\${clientId}/${baseSn}/keyRe| 键盘参数数据返回 |
| 订阅主题 | /\${clientId}/${baseSn}/stateCode | 状态码返回 |

```json
{
	"fun": "keyboardOnlineOne",	
	"baseSn":"2023031402",
	"infos": {
		"keySn": "1479824643"
	},
	"packetTag": "0"
}
```

支持设备说明

| **基站+键盘** | **支持** | **备注** |
| --- | --- | --- |
| B200-2.4G+S6 | 支持 |  |

#### 键盘心跳反馈[上报] 
接收：
fun: " KeyboardHeartbeat" 
baseId: 1//基站ID
infos:{ "hModel": "67","keySn":"1479824643","keyValue":"0","ver":"1.0.0","volt":"50"}//返回键盘反馈模式参数值

| **Json字段** | **字段含义** | **赋值及含义** |
| --- | --- | --- |
|hModel|键盘型号|75： T2-5.8G<br>67： S6-2.4G|
|keySn|键盘Sn||
|keyVer|键盘版本||
|Volt|键盘电量|T2百分比值，S6无效|

指令样例：

|**主题**|**格式**|**说明**|
| --- | --- | --- |
| 订阅主题 | /\${clientId}/${baseSn}/keyRe| 键盘参数数据返回 |
| 订阅主题 | /\${clientId}/${baseSn}/stateCode | 状态码返回 |

```json
{
	"fun": "KeyboardHeartbeat",	
	"baseSn":"2023031402",
	"infos": {
		"hModel": "67",
		"keySn": "1479824643",
		"keyValue": "0",
		"ver": "1.0.0",
		"volt": "50"
	},
	"packetTag": "0"
}
```

支持设备说明

| **基站+键盘** | **支持** | **备注** |
| --- | --- | --- |
| B100-2.4G+S6 | 支持 |出厂配置有心跳时反馈，出厂配置无心跳时不反馈|
| B200-2.4G+S6 | 支持 |出厂配置有心跳时反馈，出厂配置无心跳时不反馈|


#### S7键盘遥控器反馈[上报] 
特定的遥控器键盘反馈数据接口。

| **Json字段** | **字段含义** | **赋值及含义** |
| --- | --- | --- |
|keySn|键盘Sn||
|keyValue|值|1~17|
|count|提交次数|1~255|

指令样例：

|**主题**|**格式**|**说明**|
| --- | --- | --- |
| 订阅主题 | /\${clientId}/${baseSn}/keyRe| 键盘参数数据返回 |
| 订阅主题 | /\${clientId}/${baseSn}/stateCode | 状态码返回 |

```json
{
	"fun": "keypadRemoteControl",	
	"baseSn":"2023031402",
	"infos": {
		"keySn": "1479824643",
		"keyValue": "1",
		"count": "1"
	},
	"packetTag": "0"
}
```
键值对应请参考图片，如下：
![](img/S7遥控器键盘键值分布图.png)


支持设备说明

| **基站+键盘** | **支持** | **备注** |
| --- | --- | --- |
| B100-2.4G+S7 | 支持 ||
| B200-2.4G+S7 | 支持 ||

#### 键盘举手功能参数

|**主题**|**格式**|**说明**|
| --- | --- | --- |
| 发布主题 | /\${clientId}/${baseSn}/keyRW | 键盘参数设置,查询指令 |
| 订阅主题 | /\${clientId}/${baseSn}/keyRe| 键盘参数数据返回 |
| 订阅主题 | /\${clientId}/${baseSn}/stateCode | 状态码返回 |

读
发送：
fun: "readKeypadHandUpMode" //读键盘举手功能参数
baseId:  1//1~32 (必须指定基站)
params：{}//读取时不需要

指令样例：

```json
{
	"fun": "readKeypadHandUpMode",	
	"baseSn":"2023031402",
	"packetTag": "1"
}
```

写

发送：
fun: "writeKeypadHandUpMode" //写键盘举手功能参数
baseId: 1//1~32 (必须指定基站)
params：{"value":"0"}//

| **Json字段** | **字段含义** | **赋值及含义** |
| --- | --- | --- |
|value|举手功能开关|0：关闭举手功能<br>1：开启举手功能|

指令样例：

```json
{
	"fun": "writeKeypadHandUpMode",	
	"baseSn":"2023031402",
	"params": {
		"value": "0"
	},
	"packetTag": "1"
}
```

返回

接收：
fun: "keypadHandUpMode" 
baseId: 1//基站ID
infos:{ "value":"0"}//返回参数值

| **Json字段** | **字段含义** | **赋值及含义** |
| --- | --- | --- |
|value|举手功能开关|0：关闭举手功能<br>1：开启举手功能|

指令样例：
```json
{
	"fun": "keypadHandUpMode",	
	"baseSn":"2023031402",
	"infos": {
		"value": "0"
	},
	"packetTag": "1"
}
```


下面是键盘按了举手键后接收到指令。

接收：
fun: "keypadHandUp" 
指令样例：
```json
{	
	"fun": "keypadHandUp",	
	"baseSn":"2023031402",
	"infos": {
		"keySn": "0589445416"
	},
	"packetTag": "2"
}
```



支持设备说明

| **基站+键盘** | **支持** | **备注** |
| --- | --- | --- |
| B100-2.4G+S7 | 支持 |  |
| B200-2.4G+S7 | 支持 |  |

#### 遥控键盘关机

|**主题**|**格式**|**说明**|
| --- | --- | --- |
| 发布主题 | /\${clientId}/${baseSn}/keyRW | 键盘参数设置,查询指令 |
| 订阅主题 | /\${clientId}/${baseSn}/keyRe| 键盘参数数据返回 |
| 订阅主题 | /\${clientId}/${baseSn}/stateCode | 状态码返回 |

写
发送：
fun: "remoteKeyShutdown" //遥控键盘关机
params：{}// 
指令样例：

```json
{
	"fun": "remoteKeyShutdown",	
	"baseSn":"2023031402",
	"params": [{
		"keySn": "1837454011"
	}],
	"packetTag": "1"
}
```
返回
接收：
fun: "remoteKeyShutdown" 
baseId: 1//基站ID
infos:{"keySn":"1837454011","state":"OK"}//遥控键盘关机


指令样例：
```json
{
	"fun": "remoteKeyShutdown",	
	"baseSn":"2023031402",
	"infos": {
		"keySn": "1837454011",
		"state": "OK"
	},
	"packetTag": "1"
}
```

支持设备说明
| **基站+键盘** | **支持** | **备注** |
| --- | --- | --- |
| B100-2.4G+S6 | 支持 ||
| B200-2.4G+S6 | 支持 ||
| B200-5.8G+T2 | 支持 ||

#### 键盘暂停休眠[公司内部使用]

|**主题**|**格式**|**说明**|
| --- | --- | --- |
| 发布主题 | /\${clientId}/${baseSn}/keyRW | 键盘参数设置,查询指令 |
| 订阅主题 | /\${clientId}/${baseSn}/keyRe| 键盘参数数据返回 |
| 订阅主题 | /\${clientId}/${baseSn}/stateCode | 状态码返回 |

写

发送：
fun: "writeKeyboardPauseSleep" //键盘暂停休眠
params：{"value"} // 

| **Json字段** | **字段含义** | **赋值及含义** |
| --- | --- | --- |
|baseId|基站ID|1-32|
|value|预留|0 ：10秒有效（默认值）|


指令样例：

```json
{
	"fun": "writeKeyboardPauseSleep",	
	"baseSn":"2023031402",
	"params": {
		"value": "0"
	},
	"packetTag": "1"
}
```

返回

接收：
fun: "writeKeyboardPauseSleep" 
baseId: 1//基站ID
infos:{"value":"0"}//10秒


指令样例：

```json
{
	"fun": "writeKeyboardPauseSleep",	
	"baseSn":"2023031402",
	"infos": {
		"value": "0"
	},
	"packetTag": "1"
}
```

支持设备说明

| **基站+键盘** | **支持** | **备注** |
| --- | --- | --- |
| B100-2.4G+S6 | 支持 ||
| B200-2.4G+S6 | 支持 ||

#### 键盘短消息

|**主题**|**格式**|**说明**|
| --- | --- | --- |
| 发布主题 | /\${clientId}/${baseSn}/keyRW | 键盘参数设置,查询指令 |
| 订阅主题 | /\${clientId}/${baseSn}/keyRe| 键盘参数数据返回 |
| 订阅主题 | /\${clientId}/${baseSn}/stateCode | 状态码返回 |

写
fun: "writeKeyMessage" //写键盘短消息
params：{} // 数组对象,对象中的默认值为空字符串

| **Json字段** | **字段含义** | **赋值及含义** |
| --- | --- | --- |
|keySn|键盘SN|空字符串，为所有在线键盘|
|txt|短消息内容|字符串最长40字节[20汉字]|


指令样例：

所有键盘
```json
{
	"fun": "writeKeyMessage",	
	"baseSn":"2023031402",
	"params": {
		"txt": "最新消息"
	},
	"packetTag": "1"
}
```

返回
fun: "writeKeyMessage" 
infos:{"state":"OK"}//返回状态,成功为OK


指令样例：

```json
{
	"fun": "writeKeyMessage",	
	"baseSn":"2023031402",
	"infos": {
		"keySn": "0000000000",
		"state": "OK"
	},
	"packetTag": "1"
}
```

指定键盘

```json
{
	"fun": "writeKeyMessage",	
	"baseSn":"2023031402",
	"keySnList": [{
		"keySn": "0007899478"
	}],
	"params": {
		"txt": "最新消息"
	},
	"packetTag": "1"
}
```

返回

fun: "writeKeyMessage" 
infos:{}//数组对象,同发送的


指令样例：

```json
{	
	"fun": "writeKeyMessage",	
	"baseSn":"2023031402",
	"infos": {
		"keySn": "0007899478",
		"state": "OK"
	},
	"packetTag": "1"
}
```

支持设备说明

| **基站+键盘** | **支持** | **备注** |
| --- | --- | --- |
| B100-2.4G+S6 | 支持 ||
| B200-2.4G+S6 | 支持 ||

#### 基站语言[公司内部使用指令]

|**主题**|**格式**|**说明**|
| --- | --- | --- |
| 发布主题 | /\${clientId}/${baseSn}/keyRW | 键盘参数设置,查询指令 |
| 订阅主题 | /\${clientId}/${baseSn}/keyRe| 键盘参数数据返回 |
| 订阅主题 | /\${clientId}/${baseSn}/stateCode | 状态码返回 |

读
发送：
fun: "readBaseStationLanguage" //读基站语言
baseId: 1//1~32 (必须指定基站)
params：{}//可不填

指令样例：
```json
{
	"fun": "readBaseStationLanguage",		
	"baseSn":"2023031402",
	"packetTag": "1"
}
```



写
发送：

fun: "writeBaseStationLanguage" //写基站语言
baseId: 1 //1~32  (必须指定基站)
params：{"value":"0"}//

| **Json字段** | **字段含义** | **赋值及含义** |
| --- | --- | --- |
|baseId|指定基站ID|1~32|
|value|语言|0:默认<br>1:中文<br>2:英文|

指令样例：
```json
{
	"fun": "writeBaseStationLanguage",	
	"baseSn":"2023031402",
	"params": {
		"value": "0"
	},
	"packetTag": "1"
}
```


返回
接收：
fun: "baseStationLanguage" 
baseId: 1//基站ID
infos:{"value":"1"}//返回基站语言值

| **Json字段** | **字段含义** | **赋值及含义** |
| --- | --- | --- |
|baseId|指定基站ID|1~32|
|value|语言|0:默认<br>1:中文<br>2:英文|

指令样例：
```json
{
	"fun": "baseStationLanguage",	
	"baseSn":"2023031402",
	"infos": {
		"value": "0"
	},
	"packetTag": "1"
}
```



#### 指定键盘修改FSN[公司内部使用指令]

写

fun: "writeKeyFSN" //写键盘修改FSN
params：{} // 数组对象,对象中的默认值为空字符串

| **Json字段** | **字段含义** | **赋值及含义** |
| --- | --- | --- |
|keySnOld|键盘旧SN||
|keySnNew|键盘新SN||


指令样例：

指定键盘

```json
{
	"fun": "writeKeyFSN",	
	"baseSn":"2023031402",
	"params": {
		"keySnList": [{
				"keySnOld": "0007899478",
				"keySnNew": "0007899479"
			},
			{
				"keySnOld": "0007899488",
				"keySnNew": "0007899489"
			}
		]
	},
	"packetTag": "1"
}
```

返回

fun: "writeKeyFSN" 
infos:{}//数组对象,同发送的


指令样例：

```json
{	
	"fun": "writeKeyFSN",	
	"baseSn":"2023031402",
	"infos": {
		"keySn": "0007899478",
		"state": "OK"
	},
	"packetTag": "1"
}
```

支持设备说明
| **基站+键盘** | **支持** | **备注** |
| --- | --- | --- |
| B100-2.4G+S6 | 支持 ||
| B200-2.4G+S6 | 支持 ||

## 键盘显示设置

|**主题**|**格式**|**说明**|
| --- | --- | --- |
| 发布主题 | /\${clientId}/${baseSn}/keyRW | 键盘参数设置,查询指令 |
| 订阅主题 | /\${clientId}/${baseSn}/keyRe| 键盘参数数据返回 |
| 订阅主题 | /\${clientId}/${baseSn}/stateCode | 状态码返回 |

### 空闲标题

修改参数后设备重启生效。

发送：
fun: "writeKeypadFreeTitle" //写键盘空闲标题显示
params:{} 

| **Json字段** | **字段含义** | **赋值及含义** |
| --- | --- | --- |
|title|标题|最多8个汉字（16个字符）|

指令样例：
```json
{
	"fun": "writeKeypadFreeTitle",	
	"baseSn":"2023031402",
	"params": {
		"title": "请认真听讲"
	},
	"packetTag": "1"
}
```

接收:
fun: "writeKeypadFreeTitle" //写键盘空闲标题显示
baseId: 1//接收到指令的基站ID
infos:{}//

| **Json字段** | **字段含义** | **赋值及含义** |
| --- | --- | --- |
|keySn|键盘SN||
|state|返回信息|OK(成功)|


指令样例：

```json
{
	"fun": "writeKeypadFreeTitle",	
	"baseSn":"2023031402",
	"infos": {
		"state": "OK"
	},
	"packetTag": "1"
}
```

支持设备说明
| **基站+键盘** | **支持** | **备注** |
| --- | --- | --- |
| B200-5.8G+T2 | 支持 ||

### 自定义信息

当启动PIN码签到绑定模式，则可对键盘进行绑定操作
发送：
fun: "writeKeypadCustomInfo" //写键盘的自定义信息
params：{}//数组对象,字段不填则保留上次值。

| **Json字段** | **字段含义** | **赋值及含义** |
| --- | --- | --- |
| keySn| 键盘Sn| 不能为空|
| scoreMode| 分数模式|1:清除<br>2:字符显示(默认值)<br>3:五角星显示<br>4:爱心显示[S6有效]|
| scoreValue| 分数值|scoreMode == 1,此处无效. <br>scoreMode == 2,8个字符长度. <br>scoreMode == 3,0~6，2个分数表示1个五角星，最多3个. <br> scoreMode == 4,0~6，2个分数表示1个爱心，最多3个 [S6有效]|
|tipText|提示文本| 最多8个汉字（16个字符）,键盘第二行显示|


指令样例：
样例目的：将SN为"1479824643"的键盘积分位置设置成"99"，第二行文本位置设置成"已绑定"。

```json
{
	"fun": "writeKeypadCustomInfo",	
	"baseSn":"2023031402",
	"params": [{
		"keySn": "1479824643",
		"scoreMode": "2",
		"scoreValue": "99",
		"tipText": "已绑定"
	}],
	"packetTag": "1"
}
```

接收：

指定键盘

fun: "writeKeypadCustomInfo" //写键盘的用户信息
baseId:0 //接收到指令的基站ID
infos:{}//数组对象

| **Json字段** | **字段含义** | **赋值及含义** |
| --- | --- | --- |
|keySn|键盘SN||
|state|状态|OK(成功)|

指令样例：


```json
{
	"fun": "writeKeypadCustomInfo",	
	"baseSn":"2023031402",
	"infos": [{
		"keySn": "1479824643",
		"state": "OK"
	}],
	"packetTag": "1"
}
```


支持设备说明

| **基站+键盘** | **支持** | **备注** |
| --- | --- | --- |
| B100-2.4G+S6 | 支持 ||
| B200-2.4G+S6 | 支持 ||
| B200-5.8G+T2 | 支持 ||


### 用户姓名

当启动PIN码签到绑定模式，则可对键盘进行绑定操作

发送：
fun: "writeKeypadUserName" //写键盘的用户姓名
params：{}//数组对象,字段不填则保留上次值。

| **Json字段** | **字段含义** | **赋值及含义** |
| --- | --- | --- |
|keySn|键盘SN|不能为空|
|userName|姓名|最多24个汉字（48个字符）,键盘左上角显示|

指令样例：

```json
{
	"fun": "writeKeypadUserName",	
	"baseSn":"2023031402",
	"params": [{
		"keySn": "1479824643",
		"userName": "张三"
	}],
	"packetTag": "1"
}
```

接收：

指定键盘
fun: "writeKeypadUserName" //写键盘的用户姓名
baseId:0 //接收到指令的基站ID
infos:{}//数组对象

| **Json字段** | **字段含义** | **赋值及含义** |
| --- | --- | --- |
|keySn|键盘SN||
|state|状态|OK(成功)|


指令样例：

```json
{
	"fun": "writeKeypadUserName",	
	"baseSn":"2023031402",
	"infos": {
		"keySn": "1479824643",
		"state": "OK"
	},
	"packetTag": "1"
}
```


支持设备说明

| **基站+键盘** | **支持** | **备注** |
| --- | --- | --- |
| B100-2.4G+S6 | 支持 ||
| B200-2.4G+S6 | 支持 ||
| B200-5.8G+T2 | 支持 ||

### 指定用户姓名[C100B+S6旧款]

当启动PIN码签到绑定模式，则可对键盘进行绑定操作
发送：
fun: "writeOneKeypadUserName" //写键盘的用户姓名
params：{}//数组对象,字段不填则保留上次值。

| **Json字段** | **字段含义** | **赋值及含义** |
| --- | --- | --- |
|keySn|键盘SN|空则为所有在线键盘，其他数组值无效|
|userName|姓名|最多5个汉字（10个字符）, 键盘左上角显示|

指令样例：

```json
{
	"fun": "writeOneKeypadUserName",	
	"baseSn":"2023031402",
	"params": [{
		"keySn": "1479824643",
		"value": "张三"
	}],
	"packetTag": "1"
}
```

接收：

指定键盘
fun: "oneKeypadUserName" //写键盘的用户姓名
baseId:1 //接收到指令的基站ID
infos:{}//数组对象

| **Json字段** | **字段含义** | **赋值及含义** |
| --- | --- | --- |
|keySn|键盘SN|空则为所有在线键盘，其他数组值无效|
|userName|姓名|最多5个汉字（10个字符）, 键盘左上角显示|

指令样例：

```json
{
	"fun": "oneKeypadUserName",	
	"baseSn":"2023031402",
	"infos": {
		"keySn": "1479824643",
		"value": "张三"
	},
	"packetTag": "1"
}
```

支持设备说明

| **基站+键盘** | **支持** | **备注** |
| --- | --- | --- |
| C100B-2.4G+S6 | 支持 |S6旧款支持，不支持生僻字。|

### 功能提示预设

用来对键盘进行界面显示字符预设操作

发送：
fun: "writeKeypadFunPromptPreset" //写键盘功能提示预设
params：{}

| **Json字段** | **字段含义** | **赋值及含义** |
| --- | --- | --- |
|mode|投票模式|默认0|
|type|类型|3:发送中<br>4:已发送<br>5:在线<br>6:离线|
|title|标题|最多8个汉字（16个字符）|

指令样例：

```json
{
	"fun": "writeKeypadFunPromptPreset",	
	"baseSn":"2023031402",
	"params": {
		"mode": "0",
		"type": "3",
		"title": "提交中"
	},

	"packetTag": "1"
}
```

接收：

所有键盘

fun: "writeKeypadFunPromptPreset" //写键盘的用户信息
baseId: 1//1~32 (必须指定基站)
infos:{"state":"OK"}//返回状态,成功为OK

| **Json字段** | **字段含义** | **赋值及含义** |
| --- | --- | --- |
|state|状态|OK(成功)|


指令样例：

```json
{
	"fun": "writeKeypadFunPromptPreset",	
	"baseSn":"2023031402",
	"infos": {
		"state": "OK"
	},
	"packetTag": "1"
}
```

支持设备说明

| **基站+键盘** | **支持** | **备注** |
| --- | --- | --- |
| B100-2.4G+S6 | 支持 ||
| B200-2.4G+S6 | 支持 ||


## 键盘在线信息

注意：在用MQTT操作基站参数时需要关注的发布主题和订阅主题如下：
|**主题**|**格式**|**说明**|
| --- | --- | --- |
| 发布主题 | /\${clientId}/${baseSn}/baseRW | 基站参数设置,查询指令 |
| 订阅主题 | /\${clientId}/${baseSn}/baseRe | 基站参数数据返回 |
| 订阅主题 | /\${clientId}/${baseSn}/stateCode | 状态码返回 |

### 自动返回在线信息

基站连接成功后，自动返回所有在线的键盘信息。当键盘在线状态改变时，也会统一返回。

接收：
fun: "keypadOnLine" //键盘在线状态
infos:{} //数组对象

| **Json字段** | **字段含义** | **赋值及含义** |
| --- | --- | --- |
|baseId|基站id|keySn键盘所在基站id|
|keySn|键盘SN||
|keyVer|键盘版本||


指令样例：

```json
{
	"fun": "keypadOnLine",	
	"baseSn":"2023031402",
	"infos": [{
			"baseId": "1",
			"keySn": "1837454011",
			"ver": "1.0.6"
		},
		{
			"baseId": "1",
			"keySn": "1837454012",
			"ver": "1.0.6"
		}
	],
	"packetTag": "1"
}
```

支持设备说明

| **基站+键盘** | **支持** | **备注** |
| --- | --- | --- |
| B200-5.8G+T2| 支持 ||


### 主动获取在线信息

应用程序在需要时，也可主动获取所有基站在线键盘信息。

<font color="#dd0000" size="5">注意：请不要在开启投票业务时使用。</font><br /> 

发送：
fun: "getKeypadOnLine" //获取键盘在线状态
params:{
"times":1		//基站扫描键盘时长，单位秒 范围1-10秒 
} // 


指令样例：

```json
{
	"fun": "getKeypadOnLine",	
	"baseSn":"2023031402",
	"params": {
		"times": 2
	},
	"packetTag": "1"
}
```

接收：
fun: "keypadOnLine" //键盘在线状态
infos:{} //数组对象

| **基站+键盘** | **支持** | **备注** |
| --- | --- | --- |
|baseId|基站id|keySn键盘所在基站id|
|keySn|键盘Sn||
|keyVer|键盘版本||
|Volt|键盘电量|T2百分比值，S6无效|


指令样例：

```json
{
	"fun": "keypadOnLine",	
	"infos": [{
			"baseId": "1",
			"keySn": "1837454011",
			"ver": "1.0.6",
			"hModel": "67",
			"Volt": "100"
		},
		{
			"baseId": "1",
			"keySn": "1837454012",
			"ver": "1.0.6",
			"hModel": "67",
			"Volt": "30"
		}
	],
	"packetTag": "1"
}
```

支持设备说明
| **基站+键盘** | **支持** | **备注** |
| --- | --- | --- |
| B100-2.4G+S6 | 支持 |键盘电量：无效|
| B200-2.4G+S6 | 支持 |键盘电量：无效|
| B200-5.8G+T2 | 支持 |键盘电量：百分比值|


## 异常处理

### 基站收到数据异常

基站收到异常数据，会不做处理，并返回以下错误信息描述。

接收:
fun: "stateCode" //
infos:{ "fun":"XXXX","code":"10002"}// 


指令样例：
```json
{
	"fun": "stateCode",
	"infos": {
		"fun": "XXXX",	//函数名称
		"code": "10002"
	},
	"packetTag": "1"
}
```

| **code** | **含义** |
| --- | --- | 
|10001|不能正确解析的JSON数据|
|10002|解析JSON错误|
|20001|基站未连接|
|20002|功能不支持|
|20004|参数错误|
|20005|基站繁忙|
|30001|找不到对应的SN|
|40001|升级功能只能支持一个基站在线|
|60001|此功能必须指定键盘SN|
